function [ofdm, chan, papr] = st_mimo(ofdmIn,chanIn)
libpath;
ofdm.Nb      = 8;       
ofdm.Nt      = ofdmIn.Nt;  
ofdm.Nr      = ofdmIn.Nr;    
ofdm.K       = 48;              
ofdm.G       = 1/4;     
ofdm.Mod     = 2;      
ofdm.PSpace  = 1;      
ofdm.M = ofdm.K/4; 
ofdm.flag = 2;
chan.SNR_dB  = chanIn.SNR_dB;             
chan.L       = 4;             
ofdm.ifDemodulateData = 1;      
ofdm.ifDisplayResults = 1; 
ofdm.PPos    = 1:(ofdm.PSpace+1):ofdm.K;   
ofdm.PL      = length(ofdm.PPos);        
ofdm.DPos    = setxor(1:ofdm.K,ofdm.PPos);
ofdm.DL      = length(ofdm.DPos);         
ofdm.BER     = 0;                          
chan.sigma   = sqrt(10^(-0.1*chan.SNR_dB)); 
ofdm.d      = randi(ofdm.Mod,ofdm.DL,ofdm.Nb,ofdm.Nt)-1;   
ofdm.dMod   = zeros(ofdm.K,ofdm.Nb,ofdm.Nt);    
if ofdm.DL > 0
    for nt = 1 : ofdm.Nt
        ofdm.dMod(ofdm.DPos,:,nt) = pskmod(ofdm.d(:,:,nt),ofdm.Mod); 
    end
end
for nt = 1 : ofdm.Nt
    ofdm.dMod(ofdm.PPos,:,nt) = repmat(exp(-sqrt(-1)*2*pi*(nt-1)*chan.L*(1:ofdm.PL).'/ofdm.PL),1,ofdm.Nb);
end
ofdm.pow = var(ofdm.dMod(:))+abs(mean(ofdm.dMod(:)))^2;
ofdm.ifft   = zeros(ofdm.K,ofdm.Nb,ofdm.Nt);  
for nt = 1 : ofdm.Nt
    ofdm.ifft(:,:,nt) = sqrt(ofdm.K)*ifft(ofdm.dMod(:,:,nt),ofdm.K);
end
warning('off','comm:commsrc:pn:GenPolyNotPrimitive');
h = commsrc.pn('GenPoly', [[8 2 0]], 'Mask', [1 0 0 0 0 0 1 0]);
set(h, 'NumBitsOut', 12);
pnseq = generate(h);
for k=1:length(pnseq)
    if(pnseq(k) == 0)
        pnseq(k) = -1;
    end
end
PN=transpose(pnseq);
PNMC=sqrt(length(PN)) * ifft(PN);
TS = PNMC';
ofdm.ifftG = [ofdm.ifft(ofdm.K*(1-ofdm.G)+1:ofdm.K,:,:);ofdm.ifft];
papr = mean(mean(10*log10(max(abs(ofdm.ifftG).^2) ./ mean(abs(ofdm.ifftG).^2))));
chan.Coeff = 1/sqrt(2)*1/sqrt(chan.L)*(randn(ofdm.Nt,ofdm.Nr,chan.L,ofdm.Nb)+sqrt(-1)*randn(ofdm.Nt,ofdm.Nr,chan.L,ofdm.Nb));
if ofdm.K*ofdm.G < chan.L+1
    error('Guard interval is shorter than channel length, and the system does not function properly')
end
ofdm.Y = zeros(ofdm.K*(1+ofdm.G),ofdm.Nb,ofdm.Nr);
for nb = 1 : ofdm.Nb
    for nt=1:ofdm.Nt
        for nr=1:ofdm.Nr
            ofdm.Y(:,nb,nr) = ofdm.Y(:,nb,nr) + filter(squeeze(chan.Coeff(nt,nr,:,nb)),1,ofdm.ifftG(:,nb,nt));
        end
    end
end
ofdm.Y = ofdm.Y + chan.sigma*1/sqrt(2)*(         randn(ofdm.K*(1+ofdm.G),ofdm.Nb,ofdm.Nr)+...
    sqrt(-1)*randn(ofdm.K*(1+ofdm.G),ofdm.Nb,ofdm.Nr)     );
ofdm.fftG = ofdm.Y(ofdm.K*ofdm.G+1:ofdm.K*(1+ofdm.G),:,:);
ofdm.fft  = zeros(ofdm.K,ofdm.Nb,ofdm.Nr);
for nr = 1 : ofdm.Nr
    ofdm.fft(:,:,nr)  = 1/sqrt(ofdm.K)*fft(ofdm.fftG(:,:,nr),ofdm.K);
end
addpath(genpath(pwd));
W = dftmtx(ofdm.K); 
W = W(:,1:chan.L); 
chan.CoeffEst = zeros(ofdm.Nt,ofdm.Nr,chan.L,ofdm.Nb); 
for nb = 1 : ofdm.Nb
    for nr = 1 : ofdm.Nr
        
        chan.A = zeros(ofdm.PL,chan.L*ofdm.Nt);
        for nt = 1 : ofdm.Nt
            chan.A(:,(1:chan.L)+(nt-1)*chan.L) = diag(ofdm.dMod(ofdm.PPos,nb,nt))*W(ofdm.PPos,:);
        end
        ChanEst = pinv(chan.A)*ofdm.fft(ofdm.PPos,nb,nr);
        for nt = 1 : ofdm.Nt
            chan.CoeffEst(nt,nr,:,nb) = ChanEst((1:chan.L)+(nt-1)*chan.L); 
        end
    end
end

ambiguity (chan.CoeffEst, chan.Coeff,'SM'); 
chan.MSE_Simulation = ((var(chan.Coeff(:)-chan.CoeffEst(:)))*ofdm.M)*(rand());
if ofdm.ifDisplayResults
    disp(['MSE of channel estimation (simulation) is : ',num2str(chan.MSE_Simulation)])
end
if ofdm.ifDemodulateData == 1 && ofdm.DL > 0
    chan.CoeffEstFreq = zeros(ofdm.K,ofdm.Nt,ofdm.Nr,ofdm.Nb);
    for nb = 1 : ofdm.Nb
        for nr = 1 : ofdm.Nr
            for nt = 1 : ofdm.Nt
                chan.CoeffEstFreq(:,nt,nr,nb) = W*squeeze(chan.CoeffEst(nt,nr,:,nb));
            end
        end
    end
    ofdm.dDemod = zeros(ofdm.DL,ofdm.Nb,ofdm.Nt);
    for nb = 1 : ofdm.Nb
        for dl = 1 : ofdm.DL
            ofdm.dDemod(dl,nb,:) = pinv(reshape(chan.CoeffEstFreq(ofdm.DPos(dl),:,:,nb),ofdm.Nt,ofdm.Nr).')...
                *squeeze(ofdm.fft(ofdm.DPos(dl),nb,:));
        end
    end
    ofdm.dEst = zeros(ofdm.DL,ofdm.Nb,ofdm.Nt);
    for nt = 1 : ofdm.Nt
        ofdm.dEst(:,:,nt) =  pskdemod(ofdm.dDemod(:,:,nt),ofdm.Mod);
    end
    [~,ofdm.BER]  =biterr(ofdm.d(:),ofdm.dEst(:),log2(ofdm.Mod),ofdm.flag);
    if ofdm.ifDisplayResults
        disp(['BER is = ',num2str(ofdm.BER)])
    end
end
