clear
close all
clc
%% Input parameters
SNR_dBV     = 0:5:50;            
SNR_dBVL    = length(SNR_dBV);   
nIterations = 1000;                
ofdmIn.Nt   = 2;% number of transmit antennas
ofdmIn.Nr   = 2;% number of recieve antennas
% initilize arrays to measure PAPR performance for each method
conv_qpsk = []; % conventional QPSK MIMO Model
index_modn = []; % Index Modulcation based MIMO Model
qpsk_st = []; % QPSK ST Model 
proposed_mdl = []; % Proposed Model 

%% Outputs
MSE_CHAN_SIM_QM= zeros(nIterations,SNR_dBVL); 
CHAN_BER_QM = zeros(nIterations,SNR_dBVL); 
for cnt1 = 1 : SNR_dBVL
    chanIn.SNR_dB= SNR_dBV(cnt1);
    for cnt2 = 1 : nIterations
        [ofdm, chan, p] =qm_mimo(ofdmIn,chanIn);
        conv_qpsk = [conv_qpsk;p];
        MSE_CHAN_SIM_QM(cnt2,cnt1) = chan.MSE_Simulation;
        CHAN_BER_QM(cnt2,cnt1) = ofdm.BER;
    end
end
%% Saving the results 
avgmse1 = mean (mean(MSE_CHAN_SIM_QM));
avgber1 = mean (mean(CHAN_BER_QM));
avgpapr1 = mean (mean(conv_qpsk));


MSE_CHAN_SIM_IM= zeros(nIterations,SNR_dBVL);     %
CHAN_BER_IM = zeros(nIterations,SNR_dBVL);     %
for cnt1 = 1 : SNR_dBVL
    chanIn.SNR_dB              = SNR_dBV(cnt1); 
    for cnt2 = 1 : nIterations
        [ofdm, chan, p] =im_mimo(ofdmIn,chanIn); 
        index_modn = [index_modn;p];
        MSE_CHAN_SIM_IM(cnt2,cnt1) = chan.MSE_Simulation;
        CHAN_BER_IM(cnt2,cnt1) = ofdm.BER;
    end
end
avgmse2 = mean (mean(MSE_CHAN_SIM_IM));
avgber2 = mean (mean(CHAN_BER_IM));
avgpapr2 = mean (mean(index_modn));


MSE_CHAN_SIM_ST= zeros(nIterations,SNR_dBVL);
CHAN_BER_ST = zeros(nIterations,SNR_dBVL);

for cnt1 = 1 : SNR_dBVL
    chanIn.SNR_dB              = SNR_dBV(cnt1); 
    for cnt2 = 1 : nIterations
        [ofdm, chan, p] =st_mimo(ofdmIn,chanIn); 
        qpsk_st = [qpsk_st;p];
        MSE_CHAN_SIM_ST(cnt2,cnt1) = chan.MSE_Simulation;
        CHAN_BER_ST(cnt2,cnt1) = ofdm.BER;
    end
end
avgmse3 = mean (mean(MSE_CHAN_SIM_ST));
avgber3= mean (mean(CHAN_BER_ST));
avgpapr3 = mean (mean(qpsk_st));

MSE_CHAN_SIM_PR = zeros(nIterations,SNR_dBVL);   
CHAN_BER_PR = zeros(nIterations,SNR_dBVL);  
%% Loop
cnt3 = 0;
for cnt1 = 1 : SNR_dBVL
    chanIn.SNR_dB = SNR_dBV(cnt1);
    for cnt2 = 1 : nIterations
        [ofdm, chan, ep, pp] =imsp_pr(ofdmIn,chanIn); 
        proposed_mdl = [proposed_mdl;ep];  
        MSE_CHAN_SIM_PR(cnt2,cnt1) = chan.MSE_Simulation;
        CHAN_BER_PR(cnt2,cnt1) = ofdm.BER;
    end
end
%% Save the results of proposed
avgmse4 = mean (mean(MSE_CHAN_SIM_PR));
avgber4 = mean (mean(CHAN_BER_PR));
avgpapr4 = mean (mean(proposed_mdl));

save mse avgmse1 avgmse2 avgmse3 avgmse4
save ber avgber1 avgber2 avgber3 avgber4
save papr avgpapr1 avgpapr2 avgpapr3 avgpapr4 

%% Figures
figure(1)
clf
semilogy(SNR_dBV,(mean(MSE_CHAN_SIM_QM)),'-r.',SNR_dBV,(mean(MSE_CHAN_SIM_IM)),'-b.', SNR_dBV,mean(MSE_CHAN_SIM_ST),'-c.', SNR_dBV,mean(MSE_CHAN_SIM_PR),'-g.')
xlabel('SNR [dB]')
ylabel('Mean Square Error (MSE)')
grid on
legend('QPSK','IM [1]','QPSK-ST [2]','Proposed Framework')
figure(2)
clf
semilogy(SNR_dBV,mean(CHAN_BER_QM),'-r.', SNR_dBV,mean(CHAN_BER_IM),'-b.', SNR_dBV,mean(CHAN_BER_ST),'-c.',SNR_dBV,mean(CHAN_BER_PR),'-g.')
xlabel('SNR [dB]')
ylabel('Bit Error Rate (BER)')
grid on
legend('QPSK','IM [1]','QPSK-ST [2]','Proposed Framework')
figure (3)
semilogy(conv_qpsk','--r','linewidth',1); hold on
semilogy(index_modn','--b','linewidth',1); hold on
semilogy(qpsk_st','--g','linewidth',1); hold on
semilogy(proposed_mdl','--c','linewidth',1); hold on
semilogy(proposed_mdlp','--p','linewidth',1); hold on
grid on;
legend('QPSK','IM [1]','QPSK-ST [2]','Proposed Framework')
xlabel('Number of Iterations'); 
ylabel('Voltage (v)');
