function constellation = squareqamconst(M, varargin)
if(nargin>2)
    error(message('comm:squareQAMConst:ManyInputs'));
end
if( ~isnumeric(M) || ceil(log2(M)) ~= log2(M) || log2(M) < 0 )
    error(message('comm:squareQAMConst:Mpower'));
end

if(nargin == 1 || isempty(varargin{1}) )
    ini_phase = 0;
else
    ini_phase = varargin{1};
    if( ~isnumeric(ini_phase) || ~isscalar(ini_phase) || ~isreal(ini_phase) )
        error(message('comm:squareQAMConst:INI_PHASE'));
    end
end
if(log2(M) ==1)
    constellation = [-1 1];
    constellation = constellation.*exp(1i*ini_phase);
    return
end 

if( log2(M)/2 ~= floor(log2(M)/2) && log2(M) >3)
    nbits  = log2(M);
    constellation = zeros(1,M);	
    nIbits = (nbits + 1) / 2;
    nQbits = (nbits - 1) / 2;
    mI = 2^nIbits;
    mQ = 2^nQbits;
    for i = 0:M-1 
        I_data  = fix(i/2^nQbits);
        Q_data = bitand( i, fix(((M-1)/(2^nIbits))));
        cplx_data = (2 * I_data + 1 - mI) + 1i*(-1 * (2 * Q_data + 1 - mQ));
        %if(M>8)
            I_mag = abs(floor(real(cplx_data)));
            if(I_mag > 3 * (mI / 4))
                Q_mag = abs(floor(imag(cplx_data)));
                I_sgn = sign(real(cplx_data));
                Q_sgn = sign(imag(cplx_data));
                if(Q_mag > mQ/2)
                    cplx_data = I_sgn*(I_mag - mI/2) + 1i*( Q_sgn*(2*mQ - Q_mag));
                else
                    cplx_data = I_sgn*(mI - I_mag) + 1i*(Q_sgn*(mQ + Q_mag));
                end 
            end 
            
            %end
        constellation(i+1) =  real(cplx_data) + 1i*imag(cplx_data);
    end 
    
else 
  
    Const = idealQAMConst(M);
    newConst = [Const; conj(Const); -Const; -conj(Const) ];

    constellation = zeros(1,M);
    for k = 1:M
        ind1 = find(real(newConst) == min(real(newConst)));
        tmpArray = -1i*inf * ones(size(newConst));
        tmpArray(ind1) = newConst(ind1);
        ind2 = find(imag(tmpArray) == max(imag(tmpArray)));
        constellation(k)= newConst(ind2);
        newConst(ind2) = [];
    end
end
constellation = constellation.*exp(1i*ini_phase);
