function y = qammod(x,M, varargin)
if(nargin<2)
    error(message('comm:qammod:numarg1'));
end

if(nargin>4)
    error(message('comm:qammod:numarg2'));
end

if ( ~isreal(x) || any(any(ceil(x)~=x)) || ~isnumeric(x) ) 
    error(message('comm:qammod:xreal'));
end

if(~isreal(M) || ~isscalar(M) || M<=0 || (ceil(M)~=M) || ~isnumeric(M) )
    error(message('comm:qammod:Mreal'));
end

if( ~isnumeric(M) || ceil(log2(M)) ~= log2(M))
    error(message('comm:qammod:Mpow2'));
end

if (min(min(x)) < 0)  || (max(max(x)) > (M-1))
    error(message('comm:qammod:xreal'));
end

if(nargin>=3)
    ini_phase = varargin{1};
    if(isempty(ini_phase))
        ini_phase = 0;
    elseif(~isreal(ini_phase) || ~isscalar(ini_phase) )
        error(message('comm:qammod:ini_phaseReal'));
    end
else 
    ini_phase = 0;
end

if(nargin==2 || nargin==3)    
   Symbol_Ordering = 'bin'; 
else
    Symbol_Ordering = varargin{2};
    if (~ischar(Symbol_Ordering)) || (~strcmpi(Symbol_Ordering,'GRAY')) && (~strcmpi(Symbol_Ordering,'BIN'))
        error(message('comm:qammod:SymbolOrder'));    
    end
end
if (strcmpi(Symbol_Ordering,'GRAY'))
    x = bin2gray(x,'qam',M);  
end

const = squareqamconst(M,ini_phase);
y = genqammod(x,const);

