function z =  qamdemod(y,M,varargin)
if(nargin<2)
    error(message('comm:qamdemod:numarg1'));
end

if(nargin>4)
    error(message('comm:qamdemod:numarg2'));
end
if( ~isnumeric(y))
    error(message('comm:qamdemod:Ynum'));
end

if(~isreal(M) || ~isscalar(M) || M<=0 || (ceil(M)~=M) || ~isnumeric(M) )
    error(message('comm:qamdemod:Mreal'));
end

if( ~isnumeric(M) || ceil(log2(M)) ~= log2(M))
    error(message('comm:qamdemod:Mpow2'));
end
if(nargin==2 || isempty(varargin{1}) )    
    ini_phase = 0;
else
    ini_phase = varargin{1};
    if(~isreal(ini_phase) || ~isscalar(ini_phase)|| ~isnumeric(ini_phase) )
        error(message('comm:qamdemod:ini_phaseReal'));    
    end
end
if(nargin==2 || nargin==3 )    
   Symbol_Ordering = 'bin';
else
    Symbol_Ordering = varargin{2};
    if (~ischar(Symbol_Ordering)) || (~strcmpi(Symbol_Ordering,'GRAY')) && (~strcmpi(Symbol_Ordering,'BIN'))
        error(message('comm:qamdemod:SymbolOrder'));    
    end
end
if mod(log2(M), 2) 
    const = squareqamconst(M,ini_phase);
    z = genqamdemod(y,const);
else 
    
    wid = size(y,1);
    if(wid ==1)
        y = y(:);
    end
    y = y .* exp(-1i*ini_phase);
   sqrtM = sqrt(M);

     rIdx = round( ((real(y) + (sqrtM-1)) ./ 2) );
     rIdx(rIdx <= -1) = 0;
    rIdx(rIdx > (sqrtM-1)) = sqrtM-1;
    iIdx = round(((imag(y) + (sqrtM-1)) ./ 2));
    iIdx(iIdx <= -1) = 0;
    iIdx(iIdx > (sqrtM-1)) = sqrtM-1;
     z = sqrtM-iIdx-1 +  sqrtM*rIdx;
    if(wid == 1)
        z = z';
    end

end
if (strcmpi(Symbol_Ordering,'GRAY'))
    z = gray2bin(z,'qam',M);  
end

