function y = pskmod(x,M,varargin)
if(nargin<2)
    error(message('comm:pskmod:numarg1'));
end

if (nargin > 4)
    error(message('comm:pskmod:numarg2'));
end

if (~isreal(x) || any(any(ceil(x) ~= x)) || ~isnumeric(x))
    error(message('comm:pskmod:xreal1'));
end

if (~isreal(M) || ~isscalar(M) || M<=0 || (ceil(M)~=M) || ~isnumeric(M))
    error(message('comm:pskmod:Mreal'));
end

if(~isnumeric(M) || (ceil(log2(M)) ~= log2(M)))
    error(message('comm:pskmod:Mpow2'));
end

if ((min(min(x)) < 0) || (max(max(x)) > (M-1)))
    error(message('comm:pskmod:xreal2'));
end
if (nargin >= 3)
    ini_phase = varargin{1};
    if (isempty(ini_phase))
        ini_phase = 0;
    elseif (~isreal(ini_phase) || ~isscalar(ini_phase))
        error(message('comm:pskmod:ini_phaseReal'));
    end
else
    ini_phase = 0;
end

if(nargin==2 || nargin==3)    
   Symbol_Ordering = 'bin';
else
    Symbol_Ordering = varargin{2};
    if (~ischar(Symbol_Ordering)) || (~strcmpi(Symbol_Ordering,'GRAY')) && (~strcmpi(Symbol_Ordering,'BIN'))
        error(message('comm:pskmod:SymbolOrder'));    
    end
end

wid = size(x,1);
if (wid == 1)
    x = x(:);
end

if (strcmpi(Symbol_Ordering,'GRAY'))
    [~,gray_map] = bin2gray(x,'psk',M);   % Gray encode
    [~,index]=ismember(x,gray_map);
     x=index-1;
end
    
theta = 2*pi*x/M;

y = exp(1i*(theta + ini_phase));

if isreal(y)
    y = complex(y,0);
end

if(wid == 1)
    y = y.';
end
