function z = pskdemod(y,M,varargin)

if(nargin<2)
    error(message('comm:pskdemod:numarg1'));
end

if (nargin > 4)
    error(message('comm:pskdemod:numarg2'));
end

if( ~isnumeric(y))
    error(message('comm:pskdemod:Ynum'));
end

if (~isreal(M) || ~isscalar(M) || M<=0 || (ceil(M)~=M) || ~isnumeric(M))
    error(message('comm:pskdemod:Mreal'));
end

if(~isnumeric(M) || (ceil(log2(M)) ~= log2(M)))
    error(message('comm:pskdemod:Mpow2'));
end

if (nargin >= 3)
    ini_phase = varargin{1};
    if (isempty(ini_phase))
        ini_phase = 0;
    elseif (~isreal(ini_phase) || ~isscalar(ini_phase))
        error(message('comm:pskdemod:Ini_phaseReal'));
    end
else
    ini_phase = 0;
end

if(nargin==2 || nargin==3 )    
   Symbol_Ordering = 'bin'; % default
else
    Symbol_Ordering = varargin{2};
    if (~ischar(Symbol_Ordering)) || (~strcmpi(Symbol_Ordering,'GRAY')) && (~strcmpi(Symbol_Ordering,'BIN'))
        error(message('comm:pskdemod:SymbolOrder'));    
    end
end

wid = size(y,1);
if(wid==1)
    y = y(:);
end
y = y .* exp(-1i*ini_phase);
normFactor = M/(2*pi);
z = round((angle(y) .* normFactor));
z(z < 0) = M + z(z < 0);
if(wid == 1)
    z = z';
end
if (strcmpi(Symbol_Ordering,'GRAY'))
    [~,gray_map] = gray2bin(z,'psk',M); 
    if(size(z,1) == 1)
        temp = zeros(size(y));
        temp(:) = gray_map(z+1);
        z(:) = temp(:);
    else
        z = gray_map(z+1);
    end
end


