function constellation = idealQAMConst(M)
if (~isreal(M) || round(log2(M))~=log2(M) || log2(M)<2 )
    error(message('comm:idealQAMConst:Mpow2'))
end

constellation = [];

if ((round(sqrt(M))^2) == (sqrt(M))^2)  
    for iIndex = 1 : 2 : sqrt(M) - 1
        for qIndex = 1 : 2 : sqrt(M) - 1
            constellation = [constellation; iIndex+1i*qIndex];
        end
    end
elseif (M==8)
    constellation = [1+1i; 3+1i];
else            
    smallLen = 1;
    for bigLen = ceil(sqrt(M)) : floor(sqrt(2*M))
        while (bigLen > sqrt(M + 4*smallLen.^2))
            smallLen = smallLen + 1;
        end
        if (bigLen == sqrt(M + 4*smallLen.^2))
            break;
        else        
            bigLen = bigLen + 1;
            smallLen = 1;
        end
    end
    
    for iIndex = 1 : 2 : bigLen-1
        for qIndex = 1 : 2 : bigLen-1
            if (iIndex < bigLen-(2*smallLen-1) || qIndex < bigLen-(2*smallLen-1))
                constellation = [constellation; iIndex+1i*qIndex];
            end
        end
    end
end

return;