function y_cum = cumest(y,norder,maxlag,nsamp,overlap,flag,k1,k2)

 [ksamp,nrecs] = size(y);
 if (ksamp == 1)
     ksamp = nrecs; nrecs = 1;
 end
 if (exist('norder') ~= 1) norder = 2; end
 if (norder < 2 | norder > 4)
    error('cumulant order must be 2, 3 or 4')
 end
 if (exist('maxlag') ~= 1) maxlag = 0; end
 if (maxlag < 0)
    error ('"maxlag" must be non-negative ')
 end

 if (exist('nsamp') ~= 1) nsamp = ksamp; end
 if (nrecs > 1)           nsamp = ksamp; end
 if (nsamp <= 0 | nsamp > ksamp)
    nsamp = ksamp;
 end

 if (exist('overlap') ~= 1) overlap = 0; end
 if (nrecs > 1)             overlap = 0; end
 overlap = max(0,min(overlap,99));

 if (exist('flag') ~= 1) flag = 'biased'; end
 if (flag(1:1) ~= 'b' & flag(1:1) ~= 'B')   flag = 'unbiased';
 else, flag = 'biased';
 end

 if (exist('k1') ~= 1) k1 = 0; end
 if (exist('k2') ~= 1) k2 = 0; end

 if (norder == 2)
    y_cum = cum2est (y, maxlag, nsamp, overlap, flag);

 elseif (norder == 3)
    y_cum = cum3est (y, maxlag, nsamp, overlap, flag, k1);

 elseif (norder == 4)
    y_cum = cum4est (y, maxlag, nsamp, overlap, flag, k1, k2);

 end

return
