function   y_cum = cum3est (y, maxlag, nsamp, overlap, flag, k1)
   [n1,n2]  = size(y);
   N        = n1*n2;
   minlag   = -maxlag;
   overlap  = fix(overlap/100 * nsamp);
   nrecord  = fix( (N - overlap)/(nsamp - overlap) );
   nadvance = nsamp - overlap;

   y_cum = zeros(maxlag-minlag+1,1);

   ind = (1:nsamp)';
   nlags = 2 * maxlag + 1;
   zlag  = 1 + maxlag;
   if (flag(1) == 'b' | flag(1) == 'B')
   	scale = ones(nlags,1)/nsamp;
   else
       lsamp = nsamp - abs(k1);
       scale = [lsamp-maxlag:lsamp,lsamp-1:-1:lsamp-maxlag]';
       [m2,n2] = size(scale);
       scale = ones(m2,n2) ./ scale;
   end

   for i=1:nrecord
       x = y(ind); x = x(:) - mean(x);     
       cx = conj(x);
       z = x*0;
       if (k1 >= 0) z(1:nsamp-k1)  = x(1:nsamp-k1,:) .* cx(k1+1: nsamp,:);
       else         z(-k1+1:nsamp) = x(-k1+1:nsamp)  .* cx(1:nsamp+k1);
       end
       y_cum(zlag)  =  y_cum(zlag) + z' * x;

       for k = 1:maxlag
           y_cum(zlag-k) = y_cum(zlag-k) + z([k+1:nsamp])' * x([1:nsamp-k]);
           y_cum(zlag+k) = y_cum(zlag+k) + z([1:nsamp-k])' * x([k+1:nsamp]);
       end

       ind = ind + nadvance;
   end

   y_cum = y_cum .* scale / nrecord;

return
