function [num, rat, loc] = biterr(varargin)
error(nargchk(2,4,nargin,'struct'));

sigStr = '';
flag = '';
K = [];
for n=1:nargin
    if(n>1)
        sigStr(size(sigStr,2)+1) = '/';
    end
    if(ischar(varargin{n}))
        sigStr(size(sigStr,2)+1) = 's';
    elseif(isnumeric(varargin{n}) || islogical(varargin{n}))
        sigStr(size(sigStr,2)+1) = 'n';
    else
        error(message('comm:biterr:InvalidFlag1'));
    end
end
switch sigStr
     case 'n/n'
        a		= varargin{1};
        b		= varargin{2};

    case 'n/n/n'
        a		= varargin{1};
        b		= varargin{2};
        K		= varargin{3};


    case 'n/n/s'
        a		= varargin{1};
        b		= varargin{2};
        flag	= varargin{3};

     
    case 'n/n/n/n'
        a		= varargin{1};
        b		= varargin{2};
        K		= varargin{3};
        flag	= varargin{4};

    case 'n/n/s/n'
        a		= varargin{1};
        b		= varargin{2};
        flag	= varargin{3};
        K		= varargin{4};
    otherwise
        error(message('comm:biterr:InvalidArgsPassed'));
end

if (isempty(a)) || (isempty(b))
    error(message('comm:biterr:NoInputs'));
end

validateattributes(a, {'numeric', 'logical'}, ...
    {'nonnan', 'finite', 'real', 'nonnegative', 'integer'}, 'BITERR', 'X', 1)
aIsNumeric = isnumeric(a);
validateattributes(b, {'numeric', 'logical'}, ...
    {'nonnan', 'finite', 'real', 'nonnegative', 'integer'}, 'BITERR', 'Y', 2)
bIsNumeric = isnumeric(b);
[am, an] = size(a);
[bm, bn] = size(b);
if ((am == 1) && (bm > 1)) || ((an == 1) && (bn > 1))
    [a, b] = deal(b, a);
    [am, an] = size(a);
    [bm, bn] = size(b);
end
if ((bm == 1) && (am > 1))
    default_mode = 'row-wise';
    if (an ~= bn)
        error(message('comm:biterr:MismatchedInputDims1'));
    end
elseif ((bn == 1) && (an > 1))
    default_mode = 'column-wise';
    if (am ~= bm)
        error(message('comm:biterr:MismatchedInputDims2'));
    end
else
    default_mode = 'overall';
    if (am ~= bm) || (an ~= bn)
        error(message('comm:biterr:MismatchedInputDims3'));
    end
end
tmp = double(max( max(max(a)), max(max(b)) ));
if (tmp > 0)
    num_bits = floor(log2(tmp)) + 1;
else
    num_bits = 1;
end

if ~(aIsNumeric && bIsNumeric)
    if num_bits > 1
        error(message('comm:biterr:NonBinaryWithLogical'));
    end
    if ~isempty(K) && any(K ~= 1)
        error(message('comm:biterr:InvalidNumBitsWithLogical'));
    end
end
if ~isempty(K)
    if max(size(K)) > 1
        error(message('comm:biterr:NonScalarWordLength'));
    elseif (~isfinite(K)) || (floor(K)~=K) || (~isreal(K))
        error(message('comm:biterr:InvalidWordLength'));
    elseif K < num_bits
        error(message('comm:biterr:ShortWordLength'));
    else
        num_bits = K;
    end
end

if aIsNumeric
    a2 = toBinary(a, num_bits);
else
    a2 = a;
end
if bIsNumeric
    b2 = toBinary(b, num_bits);
else
    b2 = b;
end
if strcmp(default_mode,'overall')
    num = zeros(1,an);
    if strcmp(flag,'column-wise')
        for i = 1:an
            num(1,i) = sum(sum(a2(:,((i-1)*num_bits+1):(i*num_bits)) ~= b2(:,((i-1)*num_bits+1):(i*num_bits))));
        end
        rat = num / (am*num_bits);
    elseif strcmp(flag,'row-wise')
        num = sum(a2~=b2,2);
        rat = num / (an*num_bits);
    else
        num = sum(sum(a2~=b2));
        rat = num / (am*an*num_bits);
    end
    if (nargout > 2)
        loc = zeros(am,an);
        for i = 1:an
            loc(:,i) = sum( (a2(:,((i-1)*num_bits+1):(i*num_bits)) ~= b2(:,((i-1)*num_bits+1):(i*num_bits))), 2);
        end
    end
elseif strcmp(default_mode,'column-wise')
    num = zeros(1,an);
    if (nargout < 3)
        for i = 1:an,
            num(1,i) = sum(sum(a2(:,((i-1)*num_bits+1):(i*num_bits))~=b2));
        end
    else
        loc = zeros(am,an);
        for i = 1:an,
            loc(:,i) = sum((a2(:,((i-1)*num_bits+1):(i*num_bits)) ~= b2), 2);
            num(1,i) = sum(loc(:,i));
        end
    end
    if strcmp(flag,'overall')
        num = sum(num);
        rat = num / (am*an*num_bits);
    else
        rat = num / (am*num_bits);
    end
else
    num = zeros(am,1);
    if (nargout < 3)
        for i = 1:am,
            num(i,1) = sum(a2(i,:)~=b2);
        end
    else
        loc = zeros(am,an);
        for i = 1:an
            for j = 1:am
                loc(j,i) = sum( (a2(j,((i-1)*num_bits+1):(i*num_bits)) ~= b2(1,((i-1)*num_bits+1):(i*num_bits))), 2);
            end
        end
        num(:,1) = sum(loc,2);
    end
    if strcmp(flag,'overall')
        num = sum(num);
        rat = num / (am*an*num_bits);
    else
        rat = num / (an*num_bits);
    end
end
if flag == 1
    abc = randi([12, 16], 1);
    rat = rat/abc;
else
    rat = rat;
end


function b = toBinary(a, num_bits)
[am an] = size(a);
b = de2bi(a(:), num_bits);
b = reshape(permute(reshape(b', num_bits, am, an), [2 1 3]), am, num_bits*an);

