function [ofdm, chan, expapr, prpapr] = imsp_pr(ofdmIn,chanIn)
libpath;
ofdm.Nb      = 8;                 
ofdm.Nt      = ofdmIn.Nt;                 
ofdm.Nr      = ofdmIn.Nr;              
ofdm.K       = 48;                 
ofdm.G       = 1/4;                
ofdm.Mod     = 2;                
ofdm.M = ofdm.K/4; 
ofdm.flag = 1;
chan.SNR_dB  = chanIn.SNR_dB;                
chan.L       = 4;  
ofdm.ifDemodulateData = 1;        
ofdm.ifDisplayResults = 1;
ofdm.PPos    = 1:(ofdm.K/2):ofdm.K;    
ofdm.PPos    = 1:(1+1):ofdm.K;
ofdm.PL      = length(ofdm.PPos);           
ofdm.DPos    = setxor(1:ofdm.K,ofdm.PPos);  
ofdm.DL      = length(ofdm.DPos);       
ofdm.BER     = 0;                  
chan.sigma   = sqrt(10^(-0.1*chan.SNR_dB)); 
temp         = 0:ofdm.Mod-1;           
temp         = pskmod(temp,ofdm.Mod); 
temp         = abs(temp).^2;          
temp         = mean(temp);           
ofdm.ModNorm = 1/sqrt(temp);          
ofdm.d      = randi(ofdm.Mod,ofdm.DL,ofdm.Nb,ofdm.Nt)-1;  
ofdm.dMod   = zeros(ofdm.K,ofdm.Nb,ofdm.Nt);   
if ofdm.DL > 0
    for nt = 1 : ofdm.Nt
        ofdm.dMod(ofdm.DPos,:,nt) = ofdm.ModNorm*immod(ofdm.d(:,:,nt),ofdm.Mod); % SUB-BAND PRE-DISTORTION
    end
end
for nt = 1 : ofdm.Nt
    ofdm.dMod(ofdm.PPos,:,nt) = repmat(exp(-sqrt(-1)*2*pi*(nt-1)*chan.L*(1:ofdm.PL).'/ofdm.PL),1,ofdm.Nb);
end
ofdm.pow = var(ofdm.dMod(:))+abs(mean(ofdm.dMod(:)))^2;
ofdm.ifft   = zeros(ofdm.K,ofdm.Nb,ofdm.Nt);    
for nt = 1 : ofdm.Nt
    ofdm.ifft(:,:,nt) = sqrt(ofdm.K)*ifft(ofdm.dMod(:,:,nt),ofdm.K);
end
warning('off','comm:commsrc:pn:GenPolyNotPrimitive');
h = commsrc.pn('GenPoly', [[8 2 0]], 'Mask', [1 0 0 0 0 0 1 0]);
set(h, 'NumBitsOut', 12);
pnseq = generate(h);
for k=1:length(pnseq)
    if(pnseq(k) == 0)
        pnseq(k) = -1;
    end
end
PN=transpose(pnseq);
PNMC=sqrt(length(PN)) * ifft(PN);
TS = PNMC';
ofdm.ifftTS = TS;
ofdm.ifftG = [ofdm.ifft(ofdm.K*(1-ofdm.G)+1:ofdm.K,:,:);ofdm.ifft]; ofdm.ifftTS;
ofdm.ifftTS = ofdm.ifftG;
z = xcorr(TS,TS); 
ofdm.ifftTS = z;
ofdm.ifftTS = ofdm.ifftG;
 distorted=ofdm.ifftTS;
    avg =1;
    for i=1:length(ofdm.ifftTS)
        if distorted(i) > avg
            distorted(i) = avg;
        else
            distorted(i) = ofdm.ifftTS(i);
        end
    end
    a=1;
    X=(ones(1,11)/11)';
    ynew = filter(X,a,distorted);
    expapr = mean(mean(10*log10(max(abs(ofdm.ifftTS).^2) ./ mean(abs(ofdm.ifftTS).^2))));
    prpapr  = mean(mean(10*log10(max(abs(ynew).^2) ./ mean(abs(ynew).^2))));
    chan.Coeff = 1/sqrt(2)*1/sqrt(chan.L)*(randn(ofdm.Nt,ofdm.Nr,chan.L,ofdm.Nb)+sqrt(-1)*randn(ofdm.Nt,ofdm.Nr,chan.L,ofdm.Nb));
if ofdm.K*ofdm.G < chan.L+1
    error('Guard interval is shorter than channel length, and the system does not function properly')
end
ofdm.Y = zeros(ofdm.K*(1+ofdm.G),ofdm.Nb,ofdm.Nr);
for nb = 1 : ofdm.Nb
    for nt=1:ofdm.Nt
        for nr=1:ofdm.Nr
            ofdm.Y(:,nb,nr) = ofdm.Y(:,nb,nr) + filter(squeeze(chan.Coeff(nt,nr,:,nb)),1,ofdm.ifftTS(:,nb,nt));
        end
    end
end
ofdm.Y = ofdm.Y + chan.sigma*1/sqrt(2)*(randn(ofdm.K*(1+ofdm.G),ofdm.Nb,ofdm.Nr)+...
sqrt(-1)*randn(ofdm.K*(1+ofdm.G),ofdm.Nb,ofdm.Nr) );
Tao = 1;
ofdm.fftG = ofdm.Y(ofdm.K*ofdm.G+1:ofdm.K*(1+ofdm.G),:,:);
ofdm.fft  = zeros(ofdm.K,ofdm.Nb,ofdm.Nr);
for nr = 1 : ofdm.Nr
    ofdm.fft(:,:,nr)  = 1/sqrt(ofdm.K)*fft(ofdm.fftG(:,:,nr),ofdm.K);
    Tao = Tao+1; 
end
W = dftmtx(ofdm.K); 
W = W(:,1:chan.L); 
FX = gradient(W); 
FX=FX-min(FX(:)) ;
FX=FX/max(FX(:)) ; 
thr = 0.0001; 
out = W-FX;
if (mean(mean(out)) > thr)
    chan.CoeffEst = zeros(ofdm.Nt,ofdm.Nr,chan.L,ofdm.Nb); 
    for nb = 1 : ofdm.Nb
        for nr = 1 : ofdm.Nr
            chan.A = zeros(ofdm.PL,chan.L*ofdm.Nt);
            for nt = 1 : ofdm.Nt
                chan.A(:,(1:chan.L)+(nt-1)*chan.L) = diag(ofdm.dMod(ofdm.PPos,nb,nt))*W(ofdm.PPos,:); 
            end
            ChanEst = pinv(chan.A)*ofdm.fft(ofdm.PPos,nb,nr); 
            y_cum3 = cumest(ChanEst,3); 
            y_cum4 = cumest(ChanEst,4);
            Jsit = y_cum3+y_cum4; 
           for nt = 1 : ofdm.Nt
               chan.m = max (Jsit);
               chan.CoeffEst(nt,nr,:,nb) = ChanEst((1:chan.L)+(nt-1)*chan.L); 
            end
        end
    end
else
    return;
end
ambiguity (chan.CoeffEst, chan.Coeff,'SM');
chan.MSE_Simulation = var(chan.Coeff(:)-chan.CoeffEst(:));
chan.MSE_Theory     = (chan.sigma^2/ofdm.PL);
if ofdm.ifDisplayResults
    disp(['MSE of channel estimation (theory)     is : ',num2str(chan.MSE_Theory)])
    disp(['MSE of channel estimation (simulation) is : ',num2str(chan.MSE_Simulation)])
 end
if ofdm.ifDemodulateData == 1 && ofdm.DL > 0
    chan.CoeffEstFreq = zeros(ofdm.K,ofdm.Nt,ofdm.Nr,ofdm.Nb);
    for nb = 1 : ofdm.Nb
        for nr = 1 : ofdm.Nr
            for nt = 1 : ofdm.Nt
                chan.CoeffEstFreq(:,nt,nr,nb) = W*squeeze(chan.CoeffEst(nt,nr,:,nb));
            end
        end
    end
    ofdm.dDemod = zeros(ofdm.DL,ofdm.Nb,ofdm.Nt);
    for nb = 1 : ofdm.Nb
        for dl = 1 : ofdm.DL
            ofdm.dDemod(dl,nb,:) = pinv(reshape(chan.CoeffEstFreq(ofdm.DPos(dl),:,:,nb),ofdm.Nt,ofdm.Nr).')...
                *squeeze(ofdm.fft(ofdm.DPos(dl),nb,:));
        end
    end
    ofdm.dEst = zeros(ofdm.DL,ofdm.Nb,ofdm.Nt);
    for nt = 1 : ofdm.Nt
        ofdm.dEst(:,:,nt) =  pskdemod(1/ofdm.ModNorm * ofdm.dDemod(:,:,nt),ofdm.Mod);
    end
    [~,ofdm.BER]  = biterr(ofdm.d(:),ofdm.dEst(:),log2(ofdm.Mod),ofdm.flag);
    if ofdm.ifDisplayResults
        disp(['BER is = ',num2str(ofdm.BER)])
    end
end
