function y = immod(x,M,varargin)
if (nargin >= 3)
    ini_phase = varargin{1};
    if (isempty(ini_phase))
        ini_phase = 0;
    elseif (~isreal(ini_phase) || ~isscalar(ini_phase))
        error(message('comm:imod:ini_phaseReal'));
    end
else
    ini_phase = 0;
end
if(nargin==2 || nargin==3)    
   Symbol_Ordering = 'bin'; 
else
    Symbol_Ordering = varargin{2};
    if (~ischar(Symbol_Ordering)) || (~strcmpi(Symbol_Ordering,'GRAY')) && (~strcmpi(Symbol_Ordering,'BIN'))
        error(message('comm:imod:SymbolOrder'));    
    end
end
wid = size(x,1);
if (wid == 1)
    x = x(:);
end
if (strcmpi(Symbol_Ordering,'GRAY'))
    [~,gray_map] = bin2gray(x,'psk',M);
    [~,index]=ismember(x,gray_map);
     x=index-1;
end
theta = 2*pi*x/M;
y = exp(1i*(theta + ini_phase));
if isreal(y)
    y = complex(y,0);
end
if(wid == 1)
    y = y.';
end