function [opti_data1]=existing_approach(data_in_grd)

[row_size,col_size]=size(data_in_grd); 
rgt_data_val=ones(row_size,1);
[rwo_rgt,col_rgt]=size(rgt_data_val);
if col_rgt~=1, 
    rgt_data_val=rgt_data_val'; 
    [rwo_rgt, ~]=size(rgt_data_val); 
end
tol=eps; 

rgt_out=max(2,log10(row_size));
cnd_pro=@(k)(max( min(col_size,20), rgt_out*k)); 
[~, max_resid]=max(abs(rgt_data_val));       
[~, max2_resdi]=max(abs(data_in_grd(max_resid,:))); 
opti_data2=max_resid; 
xres_data=[1:max_resid-1, max_resid+1:row_size]; 
opti_data1=max2_resdi; 
yres_data=[1:max2_resdi-1, max2_resdi+1:col_size]; 
opti_data2 = uint16(opti_data2(:)'); 
xres_data = uint16(xres_data(:)');
opti_data1 = uint16(opti_data1(:)'); 
yres_data = uint16(yres_data(:)');
[Q,R]= qr(data_in_grd(opti_data2,opti_data1),0);
loopiter=length(opti_data1); 
svec = [];
while loopiter < min(row_size,col_size)
     x=R\(Q'*rgt_data_val(opti_data2)); 
    if length(opti_data2) < row_size
        [mr, max_resid] = sort(abs( data_in_grd(xres_data,opti_data1)*x-rgt_data_val(xres_data) ),'descend');
        xres_data = xres_data(max_resid);        
    end
    v = -Q*(R'\x);     
    [~, max2_resdi] = sort(abs( data_in_grd(opti_data2,yres_data)'*v ),'descend');
    yres_data = yres_data(max2_resdi); 
    
    if ~isempty(xres_data)
        Mc   = min(length(xres_data), loopiter+1/loopiter);  
        Mid  = length(xres_data): -floor(length(xres_data)/Mc): 1 ;                
        opti_data2=[opti_data2,xres_data(Mid)];        
        xres_data = setdiff( xres_data, xres_data(Mid));         
        [Q,R]= qr(data_in_grd(opti_data2,opti_data1),0);
    end
    
    
    no_of_yres=min( length(yres_data), cnd_pro(loopiter));  
    no_col_size=min( min(row_size,col_size)-loopiter,  loopiter );    
    iddata=round(length(yres_data): -(length(yres_data)/no_of_yres) :1 );   
    QA=Q'*data_in_grd(opti_data2, yres_data(iddata));
    [Q2,R2,e] = qr( data_in_grd(opti_data2, yres_data(iddata)) - Q*QA , 0 ); 
    Q =[ Q, Q2(:,1:no_col_size)];
    R=[R, QA(:,e(1:no_col_size)); zeros(no_col_size,loopiter), R2(1:no_col_size,1:no_col_size)];
    opti_data1 = [ opti_data1, yres_data(iddata(e(1:no_col_size))) ];
    yres_data = setdiff( yres_data, yres_data(iddata(e(1:no_col_size))));    
    
    eigmax=eigenvalue_maximum(R);
    eigmin=eigenvalue_minmum(R);
    ratio_eigmaxmin=eigmax(end)/eigmin;
    if ratio_eigmaxmin > 1/tol
         n0  = loopiter;  
        n1  = loopiter+no_col_size;
        if no_col_size==1, cut = loopiter; end
        while n1-n0> 1
            cut    = round((n0+n1)/2);
            ratio_eigmaxmin = eigmax( cut )/eigenvalue_minmum( R( 1:cut, 1:cut) );
            if ratio_eigmaxmin > 1/tol
                n1 = cut;
            else
                n0 = cut;              
            end
        end
        opti_data1 = opti_data1(1:cut);
         break;
    end
    loopiter = 2*loopiter;  
end






