#include <stdio.h>
#include <unistd.h>
#include <sys/socket.h>
#include <bluetooth/bluetooth.h>
#include <bluetooth/l2cap.h>
#include <stdlib.h>

//program to set the new packet size
int set_l2cap_mtu( int s, uint16_t mtu ) {
    struct l2cap_options opts;
    int optlen = sizeof(opts), err;
    err = getsockopt( s, SOL_L2CAP, L2CAP_OPTIONS, &opts, &optlen );
    if( ! err ) {
        opts.omtu = opts.imtu = mtu;
        err = setsockopt( s, SOL_L2CAP, L2CAP_OPTIONS, &opts, optlen );
    }
    return err;
}

int main(int argc, char **argv)
{
    struct sockaddr_l2 loc_addr = { 0 }, rem_addr = { 0 }, addr = { 0 };
    int setOptionResult, send_s, recv_s, recv_client, bytes_read, status, file_name_size, server, counter, packet_size, loops;
    const char dest[18] = "00:11:67:55:90:38";
    socklen_t opt = sizeof(rem_addr);
    char buf[100] = { 0 };
    char file_name[100]={0};
    FILE *fp;
    char tempStr [65536] ={0};
    long file_size,amount_left;
    struct timeval start, end;
    long seconds, useconds, result;
   
    //make sure a file name is loaded
    if(argc<2){
	printf("%s <file name>\n",argv[0]);
	return -1;
    }
    else
	strcpy(file_name,argv[1]);

    // allocate a socket
    recv_s = socket(AF_BLUETOOTH, SOCK_SEQPACKET, BTPROTO_L2CAP);
    send_s = socket(AF_BLUETOOTH, SOCK_SEQPACKET, BTPROTO_L2CAP);

    // bind incoming socket to port 1 of the first available 
    // local bluetooth adapter
    // set the out going connection parameters (who to connect to)
    //incomming socket
    loc_addr.l2_family = AF_BLUETOOTH;
    loc_addr.l2_bdaddr = *BDADDR_ANY;
    loc_addr.l2_psm = htobs(0x1001);
    //outgoing socket
    bind(recv_s, (struct sockaddr *)&loc_addr, sizeof(loc_addr));
    addr.l2_family = AF_BLUETOOTH;
    addr.l2_psm = htobs(0x1001);
    str2ba( dest, &addr.l2_bdaddr );

    
    // connect to server
    
    server = connect(send_s, (struct sockaddr *)&addr, sizeof(addr));
    if( server < 0 ){ 
		perror("server connection");
		return -1;
    }

    //listen for a connection
    listen(recv_s, 1);   
    
    //allow one connection
    recv_client = accept(recv_s, (struct sockaddr *)&rem_addr, &opt);
    ba2str( &rem_addr.l2_bdaddr, buf );

    fprintf(stderr, "accepted connection from %s\n", buf);
    memset(buf, 0, sizeof(buf));

    //set size of each packet 
    packet_size=672;

    //set outgoing packet size
    setOptionResult=set_l2cap_mtu(send_s,(uint16_t) packet_size);
    if( setOptionResult < 0 ) perror("set mtu");

    //open file and find its size
    file_name_size = strlen(file_name);
    fp=fopen(file_name,"r");
    fseek(fp, 0L, SEEK_END);
    file_size = ftell(fp);
    fseek(fp, 0L, SEEK_SET);
    printf("file size = %ld file name size =%d file name =%s\n",file_size,file_name_size,file_name);

    //set all counting and accumilation values to zero
    counter = 0;
    loops =0;
    result = 0;
    gettimeofday(&start, NULL);
    // send the file
    if( server == 0 ) {
		//send file name to reciever
		status = write(send_s, file_name, file_name_size);
		if( status < 0 ) perror("file name write");
		//keep reading the file until we hit the end

		while(fread(tempStr, packet_size,1,fp)==1) {
        	//start file send
			status = write(send_s, tempStr, packet_size);
			if( status < 0 ) perror("file write");
			printf("status = %d\n",status);
			//keep track of how many bytes are sent
			counter += status;
			//increment the number of loops
			loops++;
			//periodically read the new packet size 
			if (loops == 20){
				//read back new packet size
				bytes_read = read(recv_client, buf, sizeof(buf));
				packet_size = atoi(buf);
				printf("packet size = %d\n",packet_size);
				//set new packet size
				setOptionResult=set_l2cap_mtu(send_s,(uint16_t) packet_size);
    			if( setOptionResult < 0 ) perror("set mtu");
				loops=0;
			}
        }
	}
	//when at the end of the file there are a few bits left over 
	//transfer what remains
	amount_left = file_size - counter;
	fread(tempStr, amount_left,1,fp);
	status = write(send_s, tempStr, amount_left);
	if( status < 0 ) perror("last bit of file write");
	printf("Sucessfully transfered %d bytes\n",counter+status);
    
    //close the connections
    fclose(fp);
    close(send_s);
    close(recv_s);

    return 0;
}

