#include <stdio.h>
#include <unistd.h>
#include <sys/socket.h>
#include <bluetooth/bluetooth.h>
#include <bluetooth/l2cap.h>
#include <sys/time.h>
//globals used to calculate new packet size
long pre_baud = 0;
int pre_direction = 0;
int pre_jump_packet_size=672;
long pre_jump_baud = 0;
int jump_percent=0;
int climbs_before_giveup=5;
int climb_counter=0;
int new_hill_tryout=0;
char output_file_name[20] = { 0 };
//function to adjust packet size
int set_l2cap_mtu( int s, uint16_t mtu ) {
    struct l2cap_options opts;
    int optlen = sizeof(opts), err;
    err = getsockopt( s, SOL_L2CAP, L2CAP_OPTIONS, &opts, &optlen );
    if( ! err ) {
        opts.omtu = opts.imtu = mtu;
        err = setsockopt( s, SOL_L2CAP, L2CAP_OPTIONS, &opts, optlen );
    }
    return err;
}

int main(int argc, char **argv)
{
    struct sockaddr_l2 loc_addr = { 0 }, rem_addr = { 0 }, addr = { 0 };
    const char dest[18] = "00:11:67:55:90:EF";
    char buf_temp[65536] = { 0 };
    char buf[100] = { 0 };
    int recv_s,loops, recv_client, send_s, send_client ,server, bytes_read, count_bytes, status, setOptionsResult;
    socklen_t opt = sizeof(rem_addr);
    struct timeval start, end;
    long seconds, useconds, result;
    FILE *fp;
    size_t count;
    char str[10];
    int packet_size = 48;
    
	//check for the parameters to run the program
    if(argc<3){
	printf("%s <percetage of jump to new packet size>  <number up climbs before returning to orginal packet size>\n",argv[0]);
	return -1;
    }
    else{
	jump_percent =atoi(argv[1]);
	climbs_before_giveup=atoi(argv[2]);
    }

    // allocate socket
    recv_s = socket(AF_BLUETOOTH, SOCK_SEQPACKET, BTPROTO_L2CAP);
    send_s = socket(AF_BLUETOOTH, SOCK_SEQPACKET, BTPROTO_L2CAP);
    
    // bind socket to port 1 of the first available 
    // local bluetooth adapter
    loc_addr.l2_family = AF_BLUETOOTH;
    loc_addr.l2_bdaddr = *BDADDR_ANY;
    loc_addr.l2_psm = htobs(0x1001);
    bind(recv_s, (struct sockaddr *)&loc_addr, sizeof(loc_addr));
    addr.l2_family = AF_BLUETOOTH;
    addr.l2_psm = htobs(0x1001);
    str2ba( dest, &addr.l2_bdaddr );
    
    //set the recieve packet size to its maximum 
    //because it cannot be changed once the connection is established
    setOptionsResult = set_l2cap_mtu(recv_s, 65535);
    if( setOptionsResult < 0 ) perror("Set MTU");
    
    // put socket into listening mode
    listen(recv_s, 1);

    // accept one connection
    recv_client = accept(recv_s, (struct sockaddr *)&rem_addr, &opt);
    ba2str( &rem_addr.l2_bdaddr, buf );
    
    fprintf(stderr, "accepted connection from %s\n", buf);
    memset(buf, 0, sizeof(buf));
    
    //connect for sending data back
    server = connect(send_s, (struct sockaddr *)&addr, sizeof(addr));
    if( server < 0 ) perror("server connection");

	//set the file name to collect the data
    memset(output_file_name, 0, sizeof(output_file_name));
    sprintf(output_file_name,"output_p%dk%d.txt",jump_percent,climbs_before_giveup);

    //reset the log file
    fp = fopen(output_file_name, "w");
    fclose(fp);
    
    //read the name of the file that is transferred from the client
    bytes_read = read(recv_client, buf, sizeof(buf));
    //open a new file with the name that was transferred
    fp = fopen(buf, "w");
    memset(buf, 0, sizeof(buf));

    //reset the loop and accumilator values
    count_bytes=0;
    loops=0;
    packet_size=672;
    pre_direction = 0;
    climb_counter=0;
    new_hill_tryout=0;

    // read data from the client
    //have to repeat the read or else you will only get a max 1008 bytes
    do{
	//start counting the loops
	loops++;

	//start the timer only after the first loop as it was delayed for client side processing 
	if(loops ==2)
		gettimeofday(&start, NULL);

	//read the data from the client  
    	bytes_read = read(recv_client, buf_temp, sizeof(buf_temp));
    	
	//once enough loops have passed calculate the baud rate and find the new packet size
	if(loops ==20){

		//stop the timer
		gettimeofday(&end, NULL);
		//find the transfer time
		seconds  = end.tv_sec  - start.tv_sec;
    	useconds = end.tv_usec - start.tv_usec;
 		result = seconds*1000000+useconds;
		//find the new packet size
		packet_size=GetNewPacketSize(packet_size,result,loops);
		//send the new packet size the the client
		sprintf(buf,"%d",packet_size);
		status = write(send_s,buf,sizeof(buf));
		if( status < 0 ) perror("send loop");
		memset(buf, 0, sizeof(buf));
		//reset the loop counter
		loops = 0;
	}
	   	if( bytes_read > 0 ){ 
		//write the data to the file
	  	count = fwrite(buf_temp, 1, bytes_read, fp);
		//keep track of the bytes that were recived and written to the file
          	count_bytes += bytes_read;
		}
	
    }while (bytes_read > 0); //make sure there arn't any bytes still waiting to transfer

    //close the file that was being written to
    fclose(fp);

    //reset the values used to calculate the new packet size
    pre_direction = 0;
    pre_baud = 0;

    //print the total number of bytes transfered
    printf("number of bytes read %d\n", count_bytes);

    // close connection
    close(recv_client);
    close(recv_s);
    close(send_s);

return 0;
}

int GetNewPacketSize(int old_packet_size, long result, int loops){
    int new_packet_size = 48;
    int random_try = 100;
    float baud = 0;
    long baud_long=0;
    FILE *fp;
    char buf[30] = { 0 };
    int count;
    
    //open the log file
    fp = fopen(output_file_name, "a");
    //decrement the loops since we ignored the first loop
    loops--;

    //start calculating the baud rate (bits per second)
    baud = old_packet_size * 8;
    baud = baud * loops;
    baud = baud * 1000000;
    //make sure we dont get a divide by zero error
    if (!result)
		result = 10000*loops;
    //final result
    baud = baud/result;
    //convert to long
    baud_long = (long) baud;
    //print the result to the screen and then the log file
    printf("packet size = %d, baud = %ld\n",old_packet_size,baud_long);
    sprintf(buf,"%d,%ld\n00000",old_packet_size,baud_long);
    count = fwrite(buf, 1, 14, fp);
    memset(buf, 0, sizeof(buf));
    //close the log file
    fclose(fp);
	//find the new packet size
	//note: this may get overwriten if the random number for a new hill is met
    new_packet_size = climb_the_hill(old_packet_size,baud_long);

    //if this new hill has not yet been proven
    if (new_hill_tryout){
		climb_counter++;
		//if the maximum number of tries has been reached
		if(climb_counter > climbs_before_giveup){
			//reset try counters
			climb_counter = 0;
			new_hill_tryout = 0;
			//if the new hill is less successful than the previous hill then go back to previous hill
			if(baud_long<pre_jump_baud){
				new_packet_size = pre_jump_packet_size;
				pre_direction = 0;
			}
		}
    }
	//find a random number for use in the jump to a new hill
    random_try = rnd(100,0);
    //if this round has been randomly selected to jump to a new spot to try a different hill
    //and we are not currently trying out a new hill 
    if ((random_try < jump_percent) & (!new_hill_tryout)){
		//set values for the old hill for later comparison and possible reset
		pre_jump_packet_size = old_packet_size;
		pre_jump_baud = baud_long;
		//reset vlues for the new hill
		new_hill_tryout = 1;
		climb_counter = 0;
		pre_direction = 0;
		//randomly select the new packet size to try
		new_packet_size = rnd(43860,48);
    }

    //impose limits
    if (new_packet_size>43860)
		new_packet_size=43860;

    if (new_packet_size<48)
		new_packet_size=48;

    return new_packet_size;
}

//returns random number between min and max inclusively
int rnd( int max, int min ) {
    max = max - min + 1;
    return ((rand() % max)+min);
}

//hill climbing routine  
//goes in the direction of increasing transfer rate by 10% 
//reverses direction by 20% if transfer rate decreases
int climb_the_hill(int old_packet_size, long baud_long){
    int new_packet_size;
    //if uninitialized direction, then try increasing the packet size
    if (pre_direction == 0){
		new_packet_size = old_packet_size + old_packet_size/10;
		pre_direction = 1;
		//if new packet size is faster than the old, then keep goning in the same direction
    }else if (baud_long >= pre_baud){
		if (pre_direction == 1)
			new_packet_size = old_packet_size + old_packet_size/10;
		else
			new_packet_size = old_packet_size - old_packet_size/10;
    //if new packet size is slower than the old then go in the opposite direction
    }else {
		if (pre_direction == 1){
			new_packet_size = old_packet_size - old_packet_size/5;
			pre_direction = -1;
		}else{
			new_packet_size = old_packet_size + old_packet_size/5;
			pre_direction = 1;
		}
    }
    
    //set value for next calculation
    pre_baud = baud_long;

    return new_packet_size;
}
