/*
 * Decompiled with CFR 0.152.
 */
package research.util;

import research.util.Feature;
import research.util.FeatureGroup;

public class SimMeasures {
    public static double pearson(double[] f1, double[] f2) {
        double pearson = Double.NaN;
        if (f1 != null && f2 != null && f1.length == f2.length) {
            pearson = 0.0;
            double x = 0.0;
            double y = 0.0;
            double xy = 0.0;
            double xS = 0.0;
            double yS = 0.0;
            int i = 0;
            while (i < f1.length) {
                double xi = f1[i];
                double yi = f2[i];
                xy += xi * yi;
                x += xi;
                y += yi;
                xS += xi * xi;
                yS += yi * yi;
                ++i;
            }
            pearson = xy - x * y / (double)f1.length;
            pearson /= Math.sqrt((xS - x * x / (double)f1.length) * (yS - y * y / (double)f1.length));
        }
        return pearson;
    }

    public static double euclidean(double[] f1, double[] f2) {
        double euclidean = Double.NaN;
        if (f1 != null && f2 != null && f1.length == f2.length) {
            euclidean = 0.0;
            int i = 0;
            while (i < f1.length) {
                euclidean += (f1[i] - f2[i]) * (f1[i] - f2[i]);
                ++i;
            }
            euclidean = Math.sqrt(euclidean);
        }
        return euclidean;
    }

    public static double euclidean(double[] f1, Double[] f2) {
        double[] trans = new double[f2.length];
        int i = 0;
        while (i < trans.length) {
            trans[i] = f2[i];
            ++i;
        }
        return SimMeasures.euclidean(f1, trans);
    }

    public static double cohesionP(FeatureGroup group) {
        double sse = 0.0;
        int p1 = 0;
        while (p1 < group.getMembers().size()) {
            int p2 = p1 + 1;
            while (p2 < group.getMembers().size()) {
                sse += SimMeasures.pearson(group.getMembers().get(p1).getInstance(), group.getMembers().get(p2).getInstance());
                ++p2;
            }
            ++p1;
        }
        return sse / (double)(group.getMembers().size() * (group.getMembers().size() - 1) / 2);
    }

    public static double sse(FeatureGroup group) {
        double sse = 0.0;
        for (Feature p : group.getMembers()) {
            double dist = SimMeasures.euclidean(group.getInstance(), p.getInstance());
            sse += dist * dist;
        }
        return sse;
    }

    public static double sse(FeatureGroup group, double[] center) {
        double dist = SimMeasures.euclidean(group.getInstance(), center);
        return dist * dist;
    }
}

