/*
 * Decompiled with CFR 0.152.
 */
package research.util;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;

public class ListUtils {
    public static String listToString(int[] list) {
        StringBuffer buff = new StringBuffer("[");
        int i = 0;
        while (i < list.length - 1) {
            buff.append(String.valueOf(list[i]) + ", ");
            ++i;
        }
        buff.append(String.valueOf(list[list.length - 1]) + "]");
        return buff.toString();
    }

    public static String listToString(double[] list) {
        DecimalFormat df = new DecimalFormat("#.###");
        StringBuffer buff = new StringBuffer("[");
        int i = 0;
        while (i < list.length - 1) {
            buff.append(String.valueOf(df.format(list[i])) + ", ");
            ++i;
        }
        buff.append(String.valueOf(df.format(list[list.length - 1])) + "]");
        return buff.toString();
    }

    public static double maximum(double[] list) {
        double max = list[0];
        int i = 1;
        while (i < list.length) {
            if (list[i] > max) {
                max = list[i];
            }
            ++i;
        }
        return max;
    }

    public static double minimum(double[] list) {
        double min = list[0];
        int i = 1;
        while (i < list.length) {
            if (list[i] < min) {
                min = list[i];
            }
            ++i;
        }
        return min;
    }

    public static int minimum(int[] list) {
        int min = list[0];
        int i = 1;
        while (i < list.length) {
            if (list[i] < min) {
                min = list[i];
            }
            ++i;
        }
        return min;
    }

    public static int maximum(int[] list) {
        int max = list[0];
        int i = 1;
        while (i < list.length) {
            if (list[i] > max) {
                max = list[i];
            }
            ++i;
        }
        return max;
    }

    public static double computeStdev(double avg, double[] ds) {
        double sum = 0.0;
        double[] dArray = ds;
        int n = ds.length;
        int n2 = 0;
        while (n2 < n) {
            double n3 = dArray[n2];
            double diff = n3 - avg;
            sum += diff * diff;
            ++n2;
        }
        return Math.sqrt(sum /= (double)(ds.length - 1));
    }

    public static double computeStdev(double avg, int[] ds) {
        double sum = 0.0;
        int[] nArray = ds;
        int n = ds.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            double diff = (double)n3 - avg;
            sum += diff * diff;
            ++n2;
        }
        return Math.sqrt(sum /= (double)(ds.length - 1));
    }

    public static double computeStdev(double avg, List<Double> fs) {
        double sum = 0.0;
        for (Double d : fs) {
            double diff = avg - d;
            sum += diff * diff;
        }
        return Math.sqrt(sum /= (double)(fs.size() - 1));
    }

    public static double computeMean(List<Double> fs) {
        double sum = 0.0;
        for (Double d : fs) {
            sum += d.doubleValue();
        }
        return sum / (double)fs.size();
    }

    public static double computeMean(double[] ds) {
        double d = 0.0;
        double[] dArray = ds;
        int n = ds.length;
        int n2 = 0;
        while (n2 < n) {
            double n3 = dArray[n2];
            d += n3;
            ++n2;
        }
        return d / (double)ds.length;
    }

    public static double computeMean(int[] ds) {
        double d = 0.0;
        int[] nArray = ds;
        int n = ds.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            d += (double)n3;
            ++n2;
        }
        return d / (double)ds.length;
    }

    public static int minLocation(double[] list) {
        int location = 0;
        int i = 1;
        while (i < list.length) {
            if (list[i] < list[location]) {
                location = i;
            }
            ++i;
        }
        return location;
    }

    public static int maxLocation(double[] list) {
        int location = 0;
        int i = 1;
        while (i < list.length) {
            if (list[i] > list[location]) {
                location = i;
            }
            ++i;
        }
        return location;
    }

    public static int maxDiffLocation(double[] list1, double[] list2) {
        int location = 0;
        double val = list1[location] - list2[location];
        int i = 0;
        while (i < list1.length) {
            if (Math.abs(list1[i] - list2[i]) > val) {
                location = i;
                val = Math.abs(list1[i] - list2[i]);
            }
            ++i;
        }
        return location;
    }

    public static double computeMedian(double[] values) {
        double[] v = Arrays.copyOf(values, values.length);
        Arrays.sort(v);
        double median = v[v.length / 2];
        if (v.length % 2 == 0) {
            median += v[v.length / 2 - 1];
            median /= 2.0;
        }
        return median;
    }

    public static double computeMedian(List<Double> values) {
        Object[] v = values.toArray(new Double[0]);
        Arrays.sort(v);
        double median = (Double)v[v.length / 2];
        if (v.length % 2 == 0) {
            median += ((Double)v[v.length / 2 - 1]).doubleValue();
            median /= 2.0;
        }
        return median;
    }

    public static double norm(double[] vector, int n) {
        double norm = 0.0;
        int i = 0;
        while (i < vector.length) {
            double inner = 1.0;
            double comp = Math.abs(vector[i]);
            int dim = 0;
            while (dim < n) {
                inner *= comp;
                ++dim;
            }
            norm += inner;
            ++i;
        }
        if (n != 1) {
            norm = Math.pow(norm, 1.0 / (double)n);
        }
        return norm;
    }

    public static double[] sub(double[] first, double[] second) {
        double[] res = new double[first.length];
        int i = 0;
        while (i < first.length) {
            res[i] = first[i] - second[i];
            ++i;
        }
        return res;
    }

    public static double[] scalarMult(double[] vector, double scalar) {
        double[] res = new double[vector.length];
        int i = 0;
        while (i < vector.length) {
            res[i] = vector[i] * scalar;
            ++i;
        }
        return res;
    }

    public static double[] add(double[] first, double[] second) {
        double[] sum = new double[first.length];
        int i = 0;
        while (i < first.length) {
            sum[i] = first[i] + second[i];
            ++i;
        }
        return sum;
    }

    public static double[] divide(double[] numerator, double[] denominator) {
        double[] quotient = new double[numerator.length];
        int i = 0;
        while (i < numerator.length) {
            quotient[i] = numerator[i] / denominator[i];
            ++i;
        }
        return quotient;
    }
}

