/*
 * Decompiled with CFR 0.152.
 */
package research.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import research.util.Feature;

public class FeatureGroup
extends Feature
implements Comparator<FeatureGroup> {
    private int neighbors;
    private List<Feature> members;
    private double avgRelevance;
    private Feature[] kNN;
    private int originalIndex;
    private double density = Double.MIN_VALUE;

    public FeatureGroup() {
        this.members = new ArrayList<Feature>();
    }

    public FeatureGroup(FeatureGroup dp) {
        super(dp);
        this.neighbors = dp.neighbors;
        this.members = new ArrayList<Feature>();
        int i = 0;
        while (i < dp.members.size()) {
            this.members.add(new Feature(dp.members.get(i)));
            ++i;
        }
        this.instance = new double[dp.instance.length];
        i = 0;
        while (i < this.instance.length) {
            this.instance[i] = dp.instance[i];
            ++i;
        }
    }

    public void insert(Feature nv) {
        if (nv.getProximity() < this.kNN[this.kNN.length - 1].getProximity()) {
            this.kNN[this.kNN.length - 1] = nv;
            int i = this.kNN.length - 1;
            while (i != 0 && this.kNN[i].getProximity() < this.kNN[i - 1].getProximity()) {
                Feature temp = this.kNN[i];
                this.kNN[i] = this.kNN[i - 1];
                this.kNN[i - 1] = temp;
                --i;
            }
        }
    }

    public int getNeighbors() {
        return this.neighbors;
    }

    public void setNeighbors(int neighbors) {
        this.neighbors = neighbors;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(super.toString());
        s.append("\tLocal Neighbors: " + this.neighbors + "\n");
        return s.toString();
    }

    @Override
    public int compare(FeatureGroup first, FeatureGroup second) {
        if (first.neighbors > second.neighbors) {
            return 1;
        }
        if (first.neighbors < second.neighbors) {
            return -1;
        }
        return 0;
    }

    public List<Feature> getMembers() {
        return this.members;
    }

    public void setMembers(List<Feature> members) {
        this.members = members;
    }

    public double getAvgRelevance() {
        return this.avgRelevance;
    }

    public void setAvgRelevance(double avgRelevance) {
        this.avgRelevance = avgRelevance;
    }

    public Feature[] getKNN() {
        return this.kNN;
    }

    public void setKNN(Feature[] knn) {
        this.kNN = knn;
    }

    public int getOriginalIndex() {
        return this.originalIndex;
    }

    public void setOriginalIndex(int originalIndex) {
        this.originalIndex = originalIndex;
    }

    public double getDensity() {
        if (this.density == Double.MIN_VALUE) {
            this.density = (double)this.neighbors / (this.getWindow() + 1.0E-13);
        }
        return this.density;
    }

    public static FeatureGroup createSingletonGroup(Feature f) {
        FeatureGroup fg = new FeatureGroup();
        fg.setIndex(f.getIndex());
        fg.setInstance(f.getInstance());
        fg.setNeighbors(1);
        fg.getMembers().add(f);
        return fg;
    }

    public static class DensityCompare
    implements Comparator<FeatureGroup> {
        @Override
        public int compare(FeatureGroup arg0, FeatureGroup arg1) {
            if (arg0.density == Double.MIN_VALUE) {
                arg0.density = (double)arg0.neighbors / (arg0.getWindow() + 1.0E-13);
            }
            if (arg1.density == Double.MIN_VALUE) {
                arg1.density = (double)arg1.neighbors / (arg1.getWindow() + 1.0E-13);
            }
            int retVal = 0;
            if (arg0.density < arg1.density) {
                retVal = -1;
            } else if (arg0.density > arg1.density) {
                retVal = 1;
            }
            return retVal;
        }
    }

    public static class IndexCompare
    implements Comparator<FeatureGroup> {
        @Override
        public int compare(FeatureGroup arg0, FeatureGroup arg1) {
            int retVal = 0;
            if (arg0.getIndex() > arg1.getIndex()) {
                retVal = 1;
            } else if (arg0.getIndex() < arg1.getIndex()) {
                retVal = -1;
            }
            return retVal;
        }
    }

    public static class NeighborCompare
    implements Comparator<FeatureGroup> {
        @Override
        public int compare(FeatureGroup o1, FeatureGroup o2) {
            int retVal = 0;
            if (o1.neighbors > o2.neighbors) {
                retVal = 1;
            } else if (o1.neighbors < o2.neighbors) {
                retVal = -1;
            }
            return retVal;
        }
    }

    public class RelevanceCompare
    implements Comparator<FeatureGroup> {
        @Override
        public int compare(FeatureGroup arg0, FeatureGroup arg1) {
            int retVal = 0;
            if (arg0.avgRelevance > arg1.avgRelevance) {
                retVal = 1;
            } else if (arg0.avgRelevance < arg1.avgRelevance) {
                retVal = -1;
            }
            return retVal;
        }
    }
}

