/*
 * Decompiled with CFR 0.152.
 */
package research.util;

import java.util.Comparator;

public class Feature {
    private int index;
    protected double[] instance;
    private double proximity;
    private double window;

    public Feature() {
    }

    public Feature(Feature point) {
        this.index = point.index;
        this.proximity = point.proximity;
        this.window = point.window;
        this.instance = new double[point.instance.length];
        int i = 0;
        while (i < this.instance.length) {
            this.instance[i] = point.instance[i];
            ++i;
        }
    }

    public double[] getInstance() {
        return this.instance;
    }

    public void setInstance(double[] instance) {
        this.instance = (double[])instance.clone();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setProximity(double dist) {
        this.proximity = dist;
    }

    public double getProximity() {
        return this.proximity;
    }

    public double getWindow() {
        return this.window;
    }

    public void setWindow(double window) {
        this.window = window;
    }

    public boolean equals(Object other) {
        Feature f2 = (Feature)other;
        return this.index == f2.index;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Data Point:");
        sb.append("\n\tIndex: " + this.index);
        sb.append("\n\tLocation:");
        int i = 0;
        while (i < this.instance.length) {
            sb.append(" " + this.instance[i]);
            ++i;
        }
        sb.append('\n');
        return sb.toString();
    }

    public static class DCompare
    implements Comparator<Feature> {
        @Override
        public int compare(Feature p1, Feature p2) {
            if (p1.getProximity() > p2.getProximity()) {
                return 1;
            }
            return -1;
        }
    }

    public static class WindowCompare
    implements Comparator<Feature> {
        @Override
        public int compare(Feature p1, Feature p2) {
            if (p1.window > p2.window) {
                return 1;
            }
            return -1;
        }
    }
}

