/*
 * Decompiled with CFR 0.152.
 */
package research.algorithms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import research.util.Feature;
import research.util.FeatureGroup;
import research.util.ListUtils;
import research.util.SimMeasures;

public class DGF {
    private int k;
    private Feature[] data;
    private Feature[] startingPositions;
    private long seed;
    private Kernel kernel;
    private int numDirections;

    public DGF(int k, long l) {
        this.k = k;
        this.seed = l;
        this.kernel = new Flat();
        this.numDirections = 1;
    }

    public List<FeatureGroup> getFeatureGroups(double[][] insts) {
        this.data = DGF.convertData(insts);
        if (this.startingPositions == null) {
            this.startingPositions = this.data;
        }
        this.getFixedWindow(this.data, this.k);
        ArrayList<Integer> unselected = new ArrayList<Integer>(this.startingPositions.length);
        int i = 0;
        while (i < this.startingPositions.length) {
            unselected.add(i);
            ++i;
        }
        Collections.shuffle(unselected, new Random(this.seed));
        ArrayList<FeatureGroup> groups = new ArrayList<FeatureGroup>();
        while (unselected.size() > 0) {
            Feature current = this.startingPositions[(Integer)unselected.remove(0)];
            FeatureGroup group = this.findPeak(current, this.data);
            group = this.perturbPeak(group, new ArrayList<Integer>());
            group.getMembers().clear();
            group.getMembers().add(current);
            group.setNeighbors(group.getMembers().size());
            groups.add(group);
            while (this.mergePeak(groups)) {
            }
        }
        int count = 0;
        for (FeatureGroup g : groups) {
            count += g.getMembers().size();
        }
        Collections.sort(groups, new FeatureGroup.NeighborCompare());
        Collections.reverse(groups);
        return groups;
    }

    static Feature[] convertData(double[][] instances) {
        Feature[] data = new Feature[instances[0].length - 1];
        int feature = 0;
        while (feature < data.length) {
            Feature dp = new Feature();
            dp.setIndex(feature);
            double[] instance = new double[instances.length];
            int instanceNum = 0;
            while (instanceNum < instance.length) {
                instance[instanceNum] = instances[instanceNum][feature];
                ++instanceNum;
            }
            dp.setInstance(instance);
            data[feature] = dp;
            ++feature;
        }
        return data;
    }

    private FeatureGroup findPeak(Feature start, Feature[] featureSpace) {
        FeatureGroup newPeak = new FeatureGroup();
        newPeak.setWindow(start.getWindow());
        newPeak.setInstance(start.getInstance());
        double[] currCenter = new double[start.getInstance().length];
        double[] nextCenter = new double[start.getInstance().length];
        double[] unitVect = new double[currCenter.length];
        int i = 0;
        while (i < unitVect.length) {
            unitVect[i] = 1.0;
            ++i;
        }
        double[] weights = new double[featureSpace.length];
        int i2 = 0;
        while (i2 < weights.length) {
            weights[i2] = 1.0 / Math.pow(featureSpace[i2].getWindow(), 20.0);
            ++i2;
        }
        do {
            newPeak.getMembers().clear();
            i2 = 0;
            while (i2 < currCenter.length) {
                currCenter[i2] = newPeak.getInstance()[i2];
                nextCenter[i2] = 0.0;
                ++i2;
            }
            Feature[] locals = new Feature[this.k + this.numDirections];
            int i3 = 0;
            while (i3 < locals.length) {
                Feature f = new Feature();
                f.setProximity(Double.MAX_VALUE);
                locals[i3] = f;
                ++i3;
            }
            newPeak.setKNN(locals);
            Feature[] featureArray = featureSpace;
            int n = featureSpace.length;
            int f = 0;
            while (f < n) {
                Feature point = featureArray[f];
                double dist = Math.abs(SimMeasures.euclidean(point.getInstance(), currCenter));
                point.setProximity(dist);
                newPeak.insert(point);
                ++f;
            }
            double[] numerator = new double[currCenter.length];
            double[] denominator = new double[currCenter.length];
            int i4 = 0;
            while (i4 < featureSpace.length) {
                if (featureSpace[i4].getProximity() <= featureSpace[i4].getWindow()) {
                    double[] xi = featureSpace[i4].getInstance();
                    newPeak.getMembers().add(featureSpace[i4]);
                    double norm = ListUtils.norm(ListUtils.scalarMult(ListUtils.sub(currCenter, xi), 1.0 / featureSpace[i4].getWindow()), 2);
                    norm *= norm;
                    double kernResult = this.kernel.measureImpact(norm, 1.0);
                    numerator = ListUtils.add(numerator, ListUtils.scalarMult(xi, kernResult / weights[i4]));
                    denominator = ListUtils.add(denominator, ListUtils.scalarMult(unitVect, kernResult / weights[i4]));
                }
                ++i4;
            }
            nextCenter = ListUtils.divide(numerator, denominator);
            newPeak.setInstance(nextCenter);
        } while (Math.abs(SimMeasures.euclidean(currCenter, nextCenter)) > 1.0E-6);
        newPeak.setWindow(0.0);
        for (Feature f : newPeak.getMembers()) {
            if (!(f.getProximity() > newPeak.getWindow())) continue;
            newPeak.setWindow(f.getProximity());
        }
        return newPeak;
    }

    /*
     * Unable to fully structure code
     */
    private FeatureGroup perturbPeak(FeatureGroup group, List<Integer> considered) {
        perturbed = new ArrayList<FeatureGroup>(this.numDirections);
        locals = new Feature[this.numDirections];
        filled = 0;
        place = 0;
        ** GOTO lbl27
        {
            ++place;
            do {
                if (place < group.getKNN().length && group.getMembers().contains(group.getKNN()[place])) continue block0;
                if (place < group.getKNN().length) {
                    locals[filled] = group.getKNN()[place];
                    ++place;
                } else {
                    nc = group.getKNN()[group.getKNN().length - 1];
                    nnc = new Feature();
                    nnc.setProximity(1.7976931348623157E308);
                    var12_16 = this.data;
                    var11_15 = this.data.length;
                    var10_12 = 0;
                    while (var10_12 < var11_15) {
                        f = var12_16[var10_12];
                        if (!nc.equals(f) && f.getProximity() >= nc.getProximity() && f.getProximity() < nnc.getProximity()) {
                            nnc = f;
                        }
                        ++var10_12;
                    }
                    locals[filled] = nnc;
                }
                ++filled;
lbl27:
                // 2 sources

            } while (filled < this.numDirections);
        }
        i = 0;
        while (i < this.numDirections) {
            if (!considered.contains(locals[i].getIndex())) {
                if (locals[i].getProximity() == 1.7976931348623157E308) break;
                considered.add(locals[i].getIndex());
                newPoint = ListUtils.sub(locals[i].getInstance(), group.getInstance());
                newPoint = ListUtils.scalarMult(newPoint, locals[i].getWindow() / locals[i].getProximity());
                newPoint = ListUtils.add(newPoint, group.getInstance());
                f = new Feature();
                f.setInstance(newPoint);
                pGroup = this.findPeak(f, this.data);
                if (!Double.isNaN(SimMeasures.euclidean(pGroup.getInstance(), group.getInstance()))) {
                    if (SimMeasures.euclidean(pGroup.getInstance(), group.getInstance()) > group.getWindow() / 4.0) {
                        pGroup = this.perturbPeak(pGroup, considered);
                    }
                    perturbed.add(pGroup);
                    while (this.mergePeak(perturbed)) {
                    }
                }
            }
            ++i;
        }
        max = 0;
        i = 0;
        while (i < perturbed.size()) {
            if (((FeatureGroup)perturbed.get(i)).getMembers().size() > ((FeatureGroup)perturbed.get(max)).getMembers().size()) {
                max = i;
            }
            ++i;
        }
        if (perturbed.size() == 0) {
            return group;
        }
        return (FeatureGroup)perturbed.get(max);
    }

    private boolean mergePeak(List<FeatureGroup> groups) {
        FeatureGroup peak = groups.get(groups.size() - 1);
        double minDist = Double.MAX_VALUE;
        int other = 0;
        int p = 0;
        while (p < groups.size() - 1) {
            double dist = Math.abs(SimMeasures.euclidean(peak.getInstance(), groups.get(p).getInstance()));
            if (dist < minDist) {
                minDist = dist;
                other = p;
            }
            ++p;
        }
        if (other != groups.size() - 1 && minDist < groups.get(other).getWindow() && minDist < groups.get(groups.size() - 1).getWindow()) {
            double[] center = new double[peak.getInstance().length];
            int i = 0;
            while (i < center.length) {
                center[i] = (peak.getInstance()[i] + groups.get(other).getInstance()[i]) / 2.0;
                ++i;
            }
            HashSet<Feature> basin = new HashSet<Feature>();
            basin.addAll(peak.getMembers());
            basin.addAll(groups.get(other).getMembers());
            peak.getMembers().clear();
            peak.getMembers().addAll(basin);
            peak.setInstance(center);
            peak.setNeighbors(peak.getMembers().size());
            groups.remove(other);
            return true;
        }
        return false;
    }

    private double getFixedWindow(Feature[] space, int k) {
        double[][] dists = this.getRankedDistMatrix(k, space);
        double fixedWindow = 0.0;
        int i = 0;
        while (i < dists.length) {
            double avg = 0.0;
            int j = 0;
            while (j < k) {
                avg += dists[i][j];
                ++j;
            }
            fixedWindow += avg / (double)k;
            space[i].setWindow(avg / (double)k);
            ++i;
        }
        return fixedWindow / (double)dists.length;
    }

    private double[][] getRankedDistMatrix(int k, Feature[] data) {
        int d;
        double[][] rankedDist = new double[data.length][k];
        int i = 0;
        while (i < data.length) {
            d = 0;
            while (d < rankedDist[i].length) {
                rankedDist[i][d] = Double.MAX_VALUE;
                ++d;
            }
            ++i;
        }
        i = 0;
        while (i < data.length) {
            this.insert(rankedDist[i], 0.0);
            d = i + 1;
            while (d < data.length) {
                double dist = Math.abs(SimMeasures.euclidean(data[i].getInstance(), data[d].getInstance()));
                this.insert(rankedDist[i], dist);
                this.insert(rankedDist[d], dist);
                ++d;
            }
            ++i;
        }
        return rankedDist;
    }

    private void insert(double[] vals, double nv) {
        if (nv < vals[vals.length - 1]) {
            vals[vals.length - 1] = nv;
            int i = vals.length - 1;
            while (i != 0 && vals[i] < vals[i - 1]) {
                double temp = vals[i];
                vals[i] = vals[i - 1];
                vals[i - 1] = temp;
                --i;
            }
        }
    }

    public class Flat
    implements Kernel {
        @Override
        public double measureImpact(double val, double bandwidth) {
            double retVal = 1.0;
            if (val > bandwidth) {
                retVal = 0.0;
            }
            return retVal;
        }
    }

    public static interface Kernel {
        public double measureImpact(double var1, double var3);
    }
}

