/*
 * Decompiled with CFR 0.152.
 */
package research.algorithms;

import java.util.List;
import java.util.Random;
import research.algorithms.AHInstance;
import research.algorithms.DGF;
import research.util.Feature;
import research.util.FeatureGroup;

public class CGF {
    private int k;
    private double[][] instances;
    private Feature[] data;
    private long seed;
    private int numBags;

    public CGF(double[][] data, int k, int numBags, long seed) {
        this.k = k;
        this.numBags = numBags;
        this.seed = seed;
        this.data = DGF.convertData(data);
        this.instances = data;
    }

    public List<FeatureGroup> runCGF() {
        AHInstance ahc = new AHInstance(this.data);
        int i = 0;
        while (i < this.numBags) {
            System.out.println("Sub-Fold: " + (i + 1));
            double[][] foldData = this.resample(this.instances, new Random(i));
            DGF dgf = new DGF(this.k, this.seed + (long)i);
            List<FeatureGroup> newLocs = dgf.getFeatureGroups(foldData);
            ahc.addGroups(newLocs);
            ++i;
        }
        return ahc.runAHC();
    }

    private double[][] resample(double[][] source, Random random) {
        double[][] sampled = new double[source.length][source[0].length];
        int i = 0;
        while (i < sampled.length) {
            int toTake = random.nextInt(sampled.length);
            int f = 0;
            while (f < sampled[0].length) {
                sampled[i][f] = source[toTake][f];
                ++f;
            }
            ++i;
        }
        return sampled;
    }
}

