/*
 * Decompiled with CFR 0.152.
 */
package research.algorithms;

import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import research.util.Feature;
import research.util.FeatureGroup;
import research.util.ListUtils;

public class AHInstance {
    private Feature[] fullData;
    private List<AgloGroup> candidates;
    private double threshold;
    private double[][] sim;
    private int numEnsembles;

    public AHInstance(Feature[] fullData) {
        this.fullData = fullData;
        this.sim = new double[fullData.length][fullData.length];
        this.threshold = 0.5;
        this.candidates = new ArrayList<AgloGroup>(fullData.length);
        int i = 0;
        while (i < fullData.length) {
            FeatureGroup toAdd = new FeatureGroup();
            toAdd.setNeighbors(1);
            toAdd.setIndex(i);
            toAdd.setInstance(fullData[i].getInstance());
            toAdd.getMembers().add(fullData[i]);
            this.candidates.add(new AgloGroup(toAdd));
            ++i;
        }
    }

    public List<FeatureGroup> runAHC() {
        int i = 0;
        while (i < this.sim.length) {
            int j = i + 1;
            while (j < this.sim.length) {
                double[] dArray = this.sim[i];
                int n = j;
                dArray[n] = dArray[n] / (double)this.numEnsembles;
                this.sim[j][i] = this.sim[i][j];
                ++j;
            }
            ++i;
        }
        return this.runAverageLink(this.sim);
    }

    private List<FeatureGroup> runAverageLink(double[][] sim) {
        double max;
        double[][] original = new double[sim.length][sim.length];
        int i = 0;
        while (i < sim.length) {
            int j = i + 1;
            while (j < sim.length) {
                original[i][j] = sim[i][j];
                original[j][i] = sim[j][i];
                ++j;
            }
            ++i;
        }
        Random rand = new Random(6L);
        do {
            max = -1.0;
            int g1 = -1;
            int g2 = -1;
            ArrayList<Point> leaders = new ArrayList<Point>();
            int r = 0;
            while (r < sim.length) {
                int c = r + 1;
                while (c < sim.length) {
                    if (sim[r][c] > max) {
                        leaders.clear();
                        leaders.add(new Point(r, c));
                        max = sim[r][c];
                    } else if (sim[r][c] == max) {
                        leaders.add(new Point(r, c));
                    }
                    ++c;
                }
                ++r;
            }
            if (!(max >= this.threshold)) continue;
            Point winner = (Point)leaders.get(0);
            if (leaders.size() > 1) {
                winner = (Point)leaders.get(rand.nextInt(leaders.size()));
            }
            g1 = winner.x;
            g2 = winner.y;
            this.candidates.get(g1).mergeGroup(this.candidates.get(g2));
            this.candidates.set(g2, null);
            sim[g1][g2] = 0.0;
            sim[g2][g1] = 0.0;
            int r2 = 0;
            while (r2 < this.candidates.size()) {
                if (r2 != g1 || r2 != g2) {
                    double weight;
                    sim[g1][r2] = weight = this.candidates.get(g1).computeAverageLink(this.candidates.get(r2), original);
                    sim[r2][g1] = weight;
                    sim[g2][r2] = 0.0;
                    sim[r2][g2] = 0.0;
                }
                ++r2;
            }
        } while (max >= this.threshold);
        return this.collapseAggloGroups(this.candidates);
    }

    private List<FeatureGroup> collapseAggloGroups(List<AgloGroup> candidates) {
        ArrayList<FeatureGroup> finals = new ArrayList<FeatureGroup>();
        int i = candidates.size() - 1;
        while (i >= 0) {
            if (candidates.get(i) == null) {
                candidates.remove(i);
            }
            --i;
        }
        for (AgloGroup candidate : candidates) {
            FeatureGroup consensus = new FeatureGroup();
            for (Integer key : candidate.counts.keySet()) {
                consensus.getMembers().add(this.fullData[key]);
            }
            finals.add(consensus);
            double[] finalCenter = new double[this.fullData[0].getInstance().length];
            int count = 0;
            for (Integer key : candidate.counts.keySet()) {
                finalCenter = ListUtils.add(finalCenter, ListUtils.scalarMult(this.fullData[key].getInstance(), ((Integer)candidate.counts.get(key)).intValue()));
                count += ((Integer)candidate.counts.get(key)).intValue();
            }
            finalCenter = ListUtils.scalarMult(finalCenter, 1.0 / (double)count);
            consensus.setInstance(finalCenter);
            consensus.setNeighbors(consensus.getMembers().size());
        }
        return finals;
    }

    public void addGroups(List<FeatureGroup> groups) {
        ++this.numEnsembles;
        for (FeatureGroup group : groups) {
            int i = 0;
            while (i < group.getMembers().size()) {
                int j = i + 1;
                while (j < group.getMembers().size()) {
                    int indi = group.getMembers().get(i).getIndex();
                    int indj = group.getMembers().get(j).getIndex();
                    double[] dArray = this.sim[indi];
                    int n = indj;
                    dArray[n] = dArray[n] + 1.0;
                    double[] dArray2 = this.sim[indj];
                    int n2 = indi;
                    dArray2[n2] = dArray2[n2] + 1.0;
                    ++j;
                }
                ++i;
            }
        }
    }

    private class AgloGroup {
        private Map<Integer, Integer> counts = new HashMap<Integer, Integer>();
        private List<FeatureGroup> aggloGroup = new ArrayList<FeatureGroup>();

        public AgloGroup() {
        }

        public double computeMaxLink(AgloGroup agloGroup) {
            if (agloGroup == null) {
                return 0.0;
            }
            double maxLink = Double.MAX_VALUE;
            for (Integer f1 : this.counts.keySet()) {
                for (Integer f2 : agloGroup.counts.keySet()) {
                    double link = AHInstance.this.sim[f1][f2];
                    double d = maxLink = link < maxLink ? link : maxLink;
                }
            }
            return maxLink;
        }

        public double computeAverageLink(AgloGroup agloGroup, double[][] sim) {
            if (agloGroup == null) {
                return 0.0;
            }
            double avgLink = 0.0;
            for (Integer f1 : this.counts.keySet()) {
                for (Integer f2 : agloGroup.counts.keySet()) {
                    avgLink += sim[f1][f2];
                }
            }
            return avgLink / (double)(this.counts.size() * agloGroup.counts.size());
        }

        public double computeSingleLink(AgloGroup agloGroup) {
            if (agloGroup == null) {
                return 0.0;
            }
            double minLink = Double.MIN_VALUE;
            for (Integer f1 : this.counts.keySet()) {
                for (Integer f2 : agloGroup.counts.keySet()) {
                    double link = AHInstance.this.sim[f1][f2];
                    double d = minLink = link > minLink ? link : minLink;
                }
            }
            return minLink;
        }

        public void mergeGroup(AgloGroup agloGroup) {
            this.aggloGroup.addAll(agloGroup.aggloGroup);
            for (Integer key : agloGroup.counts.keySet()) {
                if (this.counts.containsKey(key)) {
                    this.counts.put(key, this.counts.get(key) + agloGroup.counts.get(key));
                    continue;
                }
                this.counts.put(key, agloGroup.counts.get(key));
            }
        }

        public AgloGroup(FeatureGroup group) {
            this();
            this.mergeGroup(group);
        }

        public void mergeGroup(FeatureGroup group) {
            this.aggloGroup.add(group);
            for (Feature f : group.getMembers()) {
                int index = f.getIndex();
                if (this.counts.containsKey(index)) {
                    this.counts.put(index, this.counts.get(index) + 1);
                    continue;
                }
                this.counts.put(index, 1);
            }
        }
    }
}

