/*
 * Decompiled with CFR 0.152.
 */
package edu.binghamton;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.regex.Pattern;
import research.algorithms.CGF;
import research.util.Feature;
import research.util.FeatureGroup;
import research.util.SimMeasures;

public class CGS {
    private CGF cgf;
    private double[][] data;

    private CGS() {
    }

    public CGS(double[][] data, int k, int t, long l) {
        if (data == null || k < 2 || t < 1) {
            throw new IllegalArgumentException("Follow the README guidelines on allowable parameters for the CGS algorithm");
        }
        this.data = data;
        this.cgf = new CGF(data, k, t, l);
    }

    public int[][] runCGS(int f) {
        if (f < 1) {
            throw new IllegalArgumentException("Follow the README guidelines on allowable parameters for the CGS algorithm");
        }
        return this.selectTopGroups(this.cgf.runCGF(), f, this.data);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 4) {
            System.err.println("Usage error.  Must specify all 4 parameters as described in the README.txt file");
            System.exit(1);
        }
        CGS cgs = new CGS();
        double[][] data = cgs.readMatrix(args[0]);
        int groupsToSelect = 0;
        int bandwidth = 0;
        int t = 0;
        try {
            groupsToSelect = Integer.parseInt(args[1]);
            bandwidth = Integer.parseInt(args[2]);
            t = Integer.parseInt(args[3]);
            if (bandwidth < 1 || t < 1) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            System.err.println("Error: n, k, and t must be positive integers.");
            System.exit(1);
        }
        CGF cgf = new CGF(data, bandwidth, t, 0L);
        List<FeatureGroup> conGroups = cgf.runCGF();
        int[][] fGroups = cgs.selectTopGroups(conGroups, groupsToSelect, data);
        int i = 0;
        while (i < fGroups.length) {
            System.out.print("Group " + (i + 1) + ": ");
            int f = 0;
            while (f < fGroups[i].length) {
                System.out.print(String.valueOf(fGroups[i][f]) + " ");
                ++f;
            }
            System.out.println();
            ++i;
        }
    }

    private int[][] selectTopGroups(List<FeatureGroup> featureGroups, int groupsToSelect, double[][] sourceData) {
        FStatistic fstat = new FStatistic();
        fstat.setInstances(sourceData);
        for (FeatureGroup peak : featureGroups) {
            double closest = Double.MAX_VALUE;
            Feature close = null;
            for (Feature point : peak.getMembers()) {
                double dist = Math.abs(SimMeasures.euclidean(point.getInstance(), peak.getInstance()));
                if (!(dist < closest)) continue;
                closest = dist;
                close = point;
            }
            peak.setAvgRelevance(fstat.getMeasure(close.getIndex()));
            if (peak.getMembers().size() <= 1) continue;
            peak.getMembers().remove(close);
            peak.getMembers().add(0, close);
        }
        Collections.sort(featureGroups, new FeatureGroup.RelevanceCompare(featureGroups.get(0)));
        Collections.reverse(featureGroups);
        int toTake = Math.min(featureGroups.size(), groupsToSelect);
        int[][] fGroups = new int[toTake][];
        int i = 0;
        while (i < fGroups.length) {
            fGroups[i] = new int[featureGroups.get(i).getMembers().size()];
            int f = 0;
            while (f < fGroups[i].length) {
                fGroups[i][f] = featureGroups.get(i).getMembers().get(f).getIndex();
                ++f;
            }
            ++i;
        }
        return fGroups;
    }

    private double[][] readMatrix(String fileName) {
        double[][] matrix = null;
        try {
            Scanner scan = new Scanner(new FileReader(fileName));
            Pattern delim = Pattern.compile("[ ,]+");
            scan.useDelimiter(delim);
            if (!scan.hasNextLine()) {
                throw new IOException();
            }
            Scanner line = new Scanner(scan.nextLine());
            line.useDelimiter(delim);
            int rows = line.nextInt();
            int cols = line.nextInt();
            matrix = new double[rows][cols];
            HashMap<String, Integer> classLabels = new HashMap<String, Integer>();
            int labelOn = 0;
            int r = 0;
            while (r < matrix.length) {
                Scanner line2 = new Scanner(scan.nextLine());
                line2.useDelimiter(delim);
                int c = 0;
                while (c < matrix[r].length - 1) {
                    matrix[r][c] = line2.nextDouble();
                    ++c;
                }
                String lb = line2.next();
                if (!classLabels.containsKey(lb)) {
                    classLabels.put(lb, labelOn);
                    ++labelOn;
                }
                matrix[r][matrix[r].length - 1] = ((Integer)classLabels.get(lb)).intValue();
                ++r;
            }
            scan.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Data file not found.");
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Data file not formatted correctly:");
            System.err.println("First line must contain # rows # cols");
            System.err.println("The next # rows lines must have # cols numbers per line");
            System.exit(1);
        }
        catch (NoSuchElementException e) {
            System.err.println("Data file not formatted correctly:");
            System.err.println("First line must contain # rows # cols");
            System.err.println("The next # rows lines must have # cols numbers per line");
            System.exit(1);
        }
        return matrix;
    }

    private class FStatistic
    extends RelevanceMeasure {
        private double[] computedValues;

        private FStatistic() {
        }

        @Override
        public void setInstances(double[][] data) {
            super.setInstances(data);
            this.computedValues = new double[data[0].length - 1];
            int i = 0;
            while (i < this.computedValues.length) {
                this.computedValues[i] = -1.0;
                ++i;
            }
        }

        @Override
        public double getMeasure(double[] values) {
            double oldRel = this.computedValues[0];
            this.computedValues[0] = -1.0;
            double[] temp = new double[this.instances.length];
            int i = 0;
            while (i < temp.length) {
                temp[i] = this.instances[i][0];
                this.instances[i][0] = values[i];
                ++i;
            }
            double retVal = this.getMeasure(0);
            int i2 = 0;
            while (i2 < temp.length) {
                this.instances[i2][0] = temp[i2];
                ++i2;
            }
            this.computedValues[0] = oldRel;
            return retVal;
        }

        @Override
        public String getName() {
            return "F-Statistic";
        }

        @Override
        public double getMeasure(int pointIndex) {
            if (this.computedValues[pointIndex] != -1.0) {
                return this.computedValues[pointIndex];
            }
            double[] u = new double[this.classCounts.length];
            int[] counts = new int[u.length];
            int i = 0;
            while (i < this.instances.length) {
                int spot;
                int n = spot = (int)this.instances[i][this.instances[i].length - 1];
                u[n] = u[n] + this.instances[i][pointIndex];
                int n2 = spot;
                counts[n2] = counts[n2] + 1;
                ++i;
            }
            double overallMean = 0.0;
            int i2 = 0;
            while (i2 < this.classCounts.length) {
                overallMean += u[i2];
                int n = i2;
                u[n] = u[n] / (double)counts[i2];
                ++i2;
            }
            overallMean /= (double)this.instances.length;
            double numerator = 0.0;
            double denominator = 0.0;
            int i3 = 0;
            while (i3 < u.length) {
                numerator += (double)counts[i3] * (u[i3] - overallMean) * (u[i3] - overallMean);
                double stdev = 0.0;
                int j = 0;
                while (j < this.instances.length) {
                    if ((int)this.instances[j][this.instances[j].length - 1] == i3) {
                        stdev += (this.instances[j][pointIndex] - u[i3]) * (this.instances[j][pointIndex] - u[i3]);
                    }
                    ++j;
                }
                denominator += stdev;
                ++i3;
            }
            this.computedValues[pointIndex] = (numerator /= (double)(u.length - 1)) / (denominator /= (double)(this.instances.length - this.classCounts.length));
            return this.computedValues[pointIndex];
        }

        @Override
        public Boolean reorderOutput() {
            return true;
        }
    }

    private abstract class RelevanceMeasure {
        protected int[] classCounts;
        protected double[][] instances;

        private RelevanceMeasure() {
        }

        public abstract String getName();

        public abstract double getMeasure(int var1);

        public void setupEvaluator(List<FeatureGroup> featureGroups) {
        }

        public Boolean reorderOutput() {
            return false;
        }

        public int[] getClassCounts() {
            return this.classCounts;
        }

        public void setClassCounts(int[] classCount) {
            this.classCounts = classCount;
        }

        public int getNumClasses() {
            assert (this.classCounts != null);
            return this.classCounts.length;
        }

        public void setClassCount(int index, int value) {
            this.classCounts[index] = value;
        }

        public void setInstances(double[][] data) {
            this.instances = data;
            HashSet<Double> classes = new HashSet<Double>();
            int i = 0;
            while (i < data.length) {
                classes.add(data[i][data[i].length - 1]);
                ++i;
            }
            this.setClassCounts(new int[classes.size()]);
            i = 0;
            while (i < this.classCounts.length) {
                this.classCounts[i] = 0;
                ++i;
            }
            int instanceNum = 0;
            while (instanceNum < data.length) {
                int n = (int)data[instanceNum][data[instanceNum].length - 1];
                this.classCounts[n] = this.classCounts[n] + 1;
                ++instanceNum;
            }
            int missed = 0;
            int i2 = 0;
            while (i2 < this.classCounts.length) {
                if (this.classCounts[i2] == 0) {
                    ++missed;
                }
                ++i2;
            }
            if (missed != 0) {
                int[] correctCount = new int[this.classCounts.length - missed];
                int c = 0;
                int i3 = 0;
                while (i3 < this.classCounts.length) {
                    if (this.classCounts[i3] != 0) {
                        correctCount[c] = this.classCounts[i3];
                        ++c;
                    }
                    ++i3;
                }
                this.classCounts = correctCount;
            }
        }

        public double[][] getInstances() {
            return this.instances;
        }

        public double getMeasure(double[] vf) {
            return 0.0;
        }
    }
}

