% Scale rows and/or columns

function X=src(X,r,c)
if issparse(X),
    if nargin<3 || isempty(c),
        % X=diag(sparse(r))*X;
        X=IMFutil(X,r,'scaleRow');
    elseif isempty(r),
        X=X*diag(sparse(c));
    else
        X=IMFutil(X*diag(sparse(c)),r,'scaleRow');
    end
else
  if ~isempty(r),
      r=full(r);
      X=X.*repmat(r(:),1,size(X,2));
  end
  if nargin>=3 && ~isempty(c),
      c=full(c);
      X=X.*repmat(c(:)',size(X,1),1);
  end
end
