function [V, gamma, BV] = LCA_update_VB_V_rb(net, A, V, BV, niter)

% [M,N]=size(A);
% 
% if nargin < 3 || isempty(V),
%   V=exp(psi(ones(size(net.rB,2),net.K)));
% end
% 
% if nargin <4 || isempty(BV),
%   BV=net.rB*V;
% end
% 
% if nargin < 5,
%   niter = 1000;
% end
% 
% for iter = 1:niter
%   old_BV = BV;
%   Y=spmult_raw(A,net.U',BV');
%   Y=nonzeros(A)./(Y+eps);
%   gamma=V.*(net.rBt*(mksparse(A,Y)'*net.U))+repmat(net.alpha',size(V,1),1);
%   V=exp(psi(gamma));
%   BV=net.rB*V;
%   if max(abs(BV - old_BV)) < 1e-10, break; end
% end

[M,N]=size(A);

if nargin <4 || isempty(BV),
  BV=net.rBt*V;
end

if nargin < 5,
  niter = 1000;
end

for iter = 1:niter
  old_BV = BV;
  Y=spmult_raw(A,net.U',BV');
  Y=nonzeros(A)./(Y+eps);  
  gamma=V.*(net.rB*(mksparse(A,Y)'*net.U))+repmat(net.alpha',size(V,1),1);  
  V=exp(psi(gamma)-repmat(psi(sum(gamma,2)),1,size(gamma,2)));
  BV=net.rBt*V;
  if max(abs(BV - old_BV)) < 1e-10, break; end
end
