function [V,gamma] = LCA_update_VB_V(net, A, V, niter)
%gamma: N x K each row of gamma is for one document
%V: N x K
[M,N]=size(A);

if nargin < 4
  niter = 1000;
end

if nargin < 3 || isempty(V),
  V=exp(psi(ones(N,net.K)));
end

for iter = 1:niter
  old_V = V;
  Y=spmult_raw(A,net.U',V'); %Y=U*V';
  Y=nonzeros(A)./(Y+eps);
  gamma=V.*(mksparse(A,Y)'*net.U)+repmat(net.alpha',N,1);
  V = exp(psi(gamma));
  if max(abs(V - old_V)) < 1e-10, break; end
end
