function p = LCA_update_U2(data, alpha, p)

% This is a second-order approximation about E[lambda].
% data(k,i) is n_ik
% alpha(j,i) is the Dirichlet parameter for lambda_ij
% p(k,j) is prob of word k in class j

[J,N] = size(alpha);
[K,J] = size(p);
pp=p.*p;

new_p = zeros(K,J);
for i = 1:N
  sum_alpha = sum(alpha(:,i));
  for j = find(alpha(:,i) > 0)'
    % m(j) = 0 for j's with alpha = 0, so they won't count
    m = (alpha(:,i)+unit(j,J)) ./ (sum_alpha + 1);
  
    s = p * m + eps;
    % s(k) = sum_j p_j(k) m_j
    s2 = pp * m;
    % s2(k) = sum_j p_j(k)^2 m_j
    ei = 1 + (s2./(s.^s) - 1)/(sum_alpha + 2);
    ei = ei ./ s .* p(:,j) * (alpha(j,i)/sum_alpha);
    
    new_p(:,j) = new_p(:,j) + ei .* data(:,i);
  end
end
p = new_p;

