function [e,V] = LCA_likelihood_VB_rb(net, data, V, BV, gamma)
% LOGPROB_VB      VB approximation for the log-prob of a document.
%
% LOGPROB_VB(p,data,alpha) returns the log-probability of each column of
% data under the generative aspect model with parameters (p,alpha).
% The integral over lambda is approximated using variational Bayes.
%
% data(k,i) is n_ik
% alpha(j,1) is the Dirichlet parameter for lambda_ij
% p(k,j) is prob of word k in class j

% N = size(data,2);
% 
% if nargin<3
%   [V,gamma,BV]= LCA_update_VB_V_rb(net,data);
%   V=nrmz(V,2);
% end
% 
% Ue= net.U.*log(net.U+eps);
% e = sum(nonzeros(data).*spmult_raw(data,Ue',BV')./(spmult_raw(data,net.U',BV')+eps));
% e = e+size(V,1)*(gammaln(sum(net.alpha)) - sum(gammaln(net.alpha)));
% e = e+(sum(gammaln(gamma(:))) - sum(gammaln(sum(gamma,2))));
% e = -e;


N = size(data,2);

Y=spmult_raw(data,net.U',BV');
A1=nonzeros(data)./(Y+eps);
A2=A1.*log(Y+eps);
V1=V.*log(V+eps);

BV1=net.rBt*V1;
Y1=spmult_raw(data,net.U',BV1');

e=size(gamma,1)*(gammaln(sum(net.alpha)) - sum(gammaln(net.alpha)));
e=e+sum(sum(A2.*Y));
e=e-sum(sum(A1.*Y1));
e=e+(sum(gammaln(gamma(:))) - sum(gammaln(sum(gamma,2))));

e = -e;
