function [e,V] = LCA_likelihood_VB(net, data, V, gamma)
% LOGPROB_VB      VB approximation for the log-prob of a document.
%
% LOGPROB_VB(p,data,alpha) returns the log-probability of each column of
% data under the generative aspect model with parameters (p,alpha).
% The integral over lambda is approximated using variational Bayes.
%
% data(k,i) is n_ik
% alpha(j,1) is the Dirichlet parameter for lambda_ij
% p(k,j) is prob of word k in class j

N = size(data,2);

if nargin<3
  [V,gamma]= LCA_update_VB_V(net,data);
  V=nrmz(V,2);%need to normalize V?
end

UV=spmult_raw(data,net.U',V')+eps;
UVlogV=spmult_raw(data,net.U',(V.*log(V))');
Ynz=nonzeros(data);

PG=psi(gamma)-repmat(psi(sum(gamma,2)),1,size(gamma,2));

e = sum(Ynz.*log(UV))-sum(Ynz.*UVlogV./UV);
e = e+N*(gammaln(sum(net.alpha)) - sum(gammaln(net.alpha)));
e = e+(sum(gammaln(gamma(:))) - sum(gammaln(sum(gamma,2))));
e = e+sum(sum(PG,1).*net.alpha');
e = e-sum(sum(PG.*gamma));
e = e+ sum(sum((PG.*V.*(mksparse(data,nonzeros(data)./UV)'*net.U))));
e = -e;
