function net=LCA_learn_VB(net, A, control)

% LCA_LEARN_VB  Estimate parameters using VB.
%    based on Minka's MLE_VB code
%
% net = LCA_LEARN_VB(net,data, control) 
%   returns approximate maximum-likelihood estimates (U,alpha). 

if nargin < 3
  control = struct;
end

control.maxiter=getOption(control,'maxiter',1000);
control.xtol=getOption(control,'xtol',1e-5);
control.learn_alpha=getOption(control,'learn_alpha',1);
control.display=getOption(control,'display',1);

[M,N] = size(A);

net.alpha=getOption(net,'alpha',[]);
if isempty(net.alpha)
  net.alpha = ones(net.K,1);
end

net.U=getOption(net,'U');
if isempty(net.U)
  net.U=nrmz(rand(M,net.K),1); % normalize each column
end

net.V=getOption(net,'V');
if isempty(net.V)
  net.V = LCA_update_VB_V(net, A, [], 50);
end

for iter = 1:control.maxiter
  old_U=net.U;
  % approximate E-step
  % run the EM loop for beta twice as often as for p
  [net.V,net.gamma] = LCA_update_VB_V(net, A, net.V, control.eiter);
  % beta(i,j) is the Dirichlet parameter for lambda_ij
  
  % approximate M-step
  net.U = nrmz(LCA_update_U1(A,net.V,net.U),1);

  if control.learn_alpha
    net.alpha = LCA_update_alpha(net.gamma,net.alpha);
  end

  change= max(abs(net.U(:) - old_U(:))/max(net.U(:)));
  if control.display
    loss = LCA_likelihood_VB(net, A, net.V, net.gamma);
    fprintf(2,'iter=%d loss=%.5e xdel=%.2e\n',iter,loss,change);
  end

  if change < control.xtol
    break
  end
end
net.iter=iter;
[net.V,net.gamma] = LCA_update_VB_V(net, A, net.V, control.eiter);
net.loss = LCA_likelihood_VB(net, A, net.V, net.gamma);
%net.V=nrmz(net.V,2);
