function net=LCA_infer_VB(net, A, control,model)

% LCA_LEARN_VB  Estimate parameters using VB.
%    based on Minka's MLE_VB code
%
% net = LCA_LEARN_VB(net,data, control) 
%   returns approximate maximum-likelihood estimates (U,alpha). 

if nargin < 3
  control = struct;
end

control.maxiter=getOption(control,'maxiter',1000);
control.xtol=getOption(control,'xtol',1e-5);
control.learn_alpha=getOption(control,'learn_alpha',1);
control.display=getOption(control,'display',1);

[M,N] = size(A);

net.U=model.U;
net.alpha=model.alpha;

net.V=getOption(net,'V');
if isempty(net.V)
  net.V = LCA_update_VB_V(net, A, [], 50);
end

for iter = 1:control.maxiter
  old_V=net.V;

  [net.V,gamma] = LCA_update_VB_V(net, A, net.V, control.eiter);

 change= max(abs(net.V(:) - old_V(:))/max(net.V(:))); 
 
  if change < control.xtol
    break
  end
end

net.loss = LCA_likelihood_VB(net, A, net.V, gamma);
net.perplexity=exp(net.loss/sum(A(:)));
net.gamma=gamma;
