function [loss1,V]=LCA_infer_NMF(net, A, control)

if nargin < 3
  control = struct;
end

control.maxiter=getOption(control,'maxiter',1000);
control.xtol=getOption(control,'xtol',1e-5);

[M,N] = size(A);

net.alphaV=getOption(net,'alphaV',0);

V = nrmz(rand(N,net.K)+(net.alphaV+0.1),2);

net.V=V;
[loss1, As]=loss(net,A);

for iter=1:control.maxiter
  old_V=net.V;
  net.V=As'*net.U.*V+net.alphaV;
  net.V=nrmz(net.V,2);

  [loss1, As]=loss(net,A);

  change= max(abs(net.V(:) - old_V(:))/max(net.V(:)));
  if change<control.xtol, break; end
end
V=net.V;

%% actual loss need to  minus \sum_i A_i log(A_i)
function [l,As]=loss(net,A)
Y=spmult_raw(A,net.U',net.V');
Anz=nonzeros(A);
l=sum(Y)-sum(Anz);
Y=Anz./max(Y,eps);
l=l+sum(Anz.*log(Y));
if nargout>1, As=mksparse(A,Y); end
