clear
load TDT10
%load TDT10_Subset500
%A=Data;

Label=Label+1;
pset=1:2:size(Data,2);
pset2=2:2:size(Data,2);
Data1=Data(:,pset);
Data2=Data(:,pset2);
K=10;

control.xtol=1e-4;
net=LCA(K);
net.alphaU=0.1;
net.alphaV=0.1;
net.alpha=ones(net.K,1);

net_NMF=LCA_learn_NMF(net,Data1,control);
net_NMFrb=LCA_learn_NMF_rb(net,Data1,control);
net_VB=LCA_learn_VB(net,Data1,control);
net_MC=LCA_learn_MC(net,Data1,control);
% net_EP=LCA_learn_EP(net,Data1,control);

[dummy,ret1_NMF]=max(net_NMF.V');
[R,P,F]=infoeval(ret1_NMF,Label(pset))

[dummy,ret1_NMFrb]=max((net.rB*net_NMFrb.V)');
[R,P,F]=infoeval(ret1_NMFrb,Label(pset))

[dummy,ret1_VB]=max(net_VB.V');
[R,P,F]=infoeval(ret1_VB,Label(pset))

% negative log-likelihood (integrated)
negLogLI_VB=LCA_infer_VB(net_VB,Data2)
negLogLI_NMF=LCA_infer_VB(net_NMF,Data2)
negLogLI_MC=LCA_infer_VB(net_MC,Data2)

% negative log-likelihood (profile)
negLogLP_VB=LCA_infer_NMF(net_VB,Data2)
[negLogLP_NMF,V2_NMF]=LCA_infer_NMF(net_NMF,Data2);
negLogLP_NMF
[dummy,ret2_NMF]=max(V2_NMF');
[R,P,F]=infoeval(ret2_NMF,Label(pset2))

negLogLP_MC=LCA_infer_NMF(net_MC,Data2)

%%%
net.rB=inv_sp_lu(B');
net_VBrb=LCA_learn_VB_rb(net,Data,control);
[dummy,ret1_VBrb]=max((net.rB*net_VBrb.V)');
[R,P,F]=infoeval(ret1_VBrb,Label(pset))

