function ret=test_topics(paras,control,methods)

if(paras.display)
    fprintf(1,'Input file=%s\n',paras.data);
end

load(paras.data);


if(isfield(paras,'mData'))
    Data=paras.mData;
end

if(isfield(paras,'mCitation'))
    citation=paras.mCitation;
end

if(isfield(paras,'mLabel'))
    Label=paras.mLabel;
end

N=size(Data,2);
if ~isfield(paras,'id_map')
   paras.id_map=[(1:N)' (1:N)']; 
end

[Prob Data]=ProcessData(Data,control);


%Label=Label-min(Label)+1;
tmpindex=find(Label>=0);
Label(tmpindex)=Label(tmpindex)-min(Label(tmpindex))+1;
class=unique(Label);
class=class(find(class>0));
actual_k=length(class);

%if(paras.k(3)>actual_k)   paras.k(3)=actual_k; end

ret.mean=[];
ret.var=[];

hasbase=0;
matfilename=paras.data;
for i=1:size(methods,1)
    if(isempty(methods{i}))
        break;
    end
    matfilename=strcat(matfilename,'_',methods{i});
    switch methods{i}
        case {'CT_kl','CT_l2','LCA_Base','LCA_Base_infer'}
            hasbase=1;
    end        
end

paras.run=1;
for k=paras.k(1):paras.k(2):paras.k(3)

    result_base=[];
    fprintf(1,'k=%d\n',k);
    rand('state',control.seed);
    %for run=1:paras.run
  
       
        X=Data;
        result=[];
        if exist('citation','var')            
            control.citation=citation;
            tmp=find(sum(control.citation,2)==0);
            if ~isempty(tmp)
                for i=1:length(tmp)
                    control.citation(tmp(i),tmp(i))=1;
                end
            end
            control.citation=control.citation.*repmat(sqrt(sum(control.citation,1)),size(control.citation,1),1);
        end
        if(hasbase==1)
            BASE=ComputeBase(X,control);
        end
        
        for trial=1:paras.trial            
            fprintf(1,'=======================\n');
            result1=[];            
            for i=1:size(methods,1)                
                if(isempty(methods{i}))
                    break;
                end                
                fhandle=str2func(methods{i});                               
            
                switch methods{i}
                    case 'LINK_LDA'
                        netinput=rand_init_new(k,size(Prob,1)+size(citation,2),size(Prob,2));
                        netinput.data=[Prob; citation'];
                        fhandle=str2func('test_LCA');
                    otherwise
                        netinput=rand_init_new(k,size(Prob,1),size(Prob,2));
                        netinput.data=Prob;
                end
                
                if(hasbase==1)
                    netinput.BASE=BASE;
                end
                netinput.k=k;
                netinput.label=Label;
                
                tmp=fhandle(netinput,control);


                Topics(trial).net=tmp;

                tmp.ac_mi=[tmp.ac_mi 0];
                result1=[result1 tmp.ac_mi];                
                interval=length(tmp.ac_mi);
            end
            result=[result;result1];
        end     

        [dummy,index]=max(result,[],1);        
        tmp=[];
        for i=1:(size(result,2)/interval)
            tmp=[tmp result(index(interval*i-interval+1),(interval*i-interval+1):(interval*i))];
        end
        result_base=[result_base;tmp];
        

        net=Topics(index(1)).net;
        mat_topics=paras.data;
        if(isfield(paras,'year'))
            mat_topics=strcat(mat_topics,'_',paras.year);
        end
        mat_topics=strcat(mat_topics,'_',methods{1},'_Topics_',num2str(k));
        
        net.id_map=paras.id_map;
        net.datafile=paras.data;
        net.mData=Prob;
        save(mat_topics,'net');
        %Extract_topics(paras.data,mat_topics);
        Rec(mat_topics);
  

%    end
%     fprintf(fid,'AC,MI(LFN KL)=%.3f(%.3f), %.3f(%.3f)\n',result(1),result_std(1),result(2),result_std(2));
%     fprintf(fid,'AC,MI(LFN L2)=%.3f(%.3f), %.3f(%.3f)\n',result(3),result_std(3),result(4),result_std(4));
%     fprintf(fid,'AC,MI(NMF KL)=%.3f(%.3f), %.3f(%.3f)\n',result(5),result_std(5),result(6),result_std(6));
%     fprintf(fid,'AC,MI(NMF L2)=%.3f(%.3f), %.3f(%.3f)\n',result(7),result_std(7),result(8),result_std(8));
end
