function ret=test_perplexity(paras,control,methods)

% paras.data='TDT10.mat';
% paras.display=false;
% paras.run = 20; 
% paras.trial=10;
% paras.k=[2 10]

if(paras.display)
    fprintf(1,'Input file=%s\n',paras.data);
end
load(paras.data);

control.proc_data=1;
[Prob Data]=ProcessData(Data,control);
N=size(Prob,2);

ret.mean=[];
ret.var=[];

hasbase=1;

matfilename=paras.data;
for i=1:size(methods,1)
    if(isempty(methods{i}))
        break;
    end
    matfilename=strcat(matfilename,'_',methods{i});
end    
matfilename=strcat(matfilename,'_','perp');
matfilename=strcat(matfilename,'_',num2str(control.alpha));


filename=sprintf('%s_%d.result',matfilename,control.suffix);
matfilename=strcat(matfilename,'.mat');
fid=fopen(filename,'w');


%split into test and train set
perp=control.perplexity; %training set ratio
rand('state',control.seed);
trainno=ceil(N*perp);
index=randperm(N);
TrainIndex=index(1:trainno);
index(1:trainno)=[];
TestIndex=index;

X=Data(:,TestIndex);
if exist('citation','var')
    control.citation=citation(TestIndex,TestIndex);
    tmp=find(sum(control.citation,2)==0);
    if ~isempty(tmp)
        for i=1:length(tmp)
            control.citation(tmp(i),tmp(i))=1;
        end
    end
    control.citation=control.citation.*repmat(sqrt(sum(control.citation,1)),size(control.citation,1),1);
end

TEST_BASE=ComputeBase(X,control);

X=Data(:,TrainIndex);
if exist('citation','var')
    control.citation=citation(TrainIndex,TrainIndex);
    tmp=find(sum(control.citation,2)==0);
    if ~isempty(tmp)
        for i=1:length(tmp)
            control.citation(tmp(i),tmp(i))=1;
        end
    end
    control.citation=control.citation.*repmat(sqrt(sum(control.citation,1)),size(control.citation,1),1);
end

BASE=ComputeBase(X,control);

        
for k=paras.k(1):paras.k(2):paras.k(3)
    fprintf(fid,'Results averaged over %d(k=%d)\n',paras.run,k);
    result_base=[];
    fprintf(1,'k=%d\n',k);
    rand('state',control.seed);    
%    for run=1:paras.run
        result=[];
        for trial=1:paras.trial
            fprintf(1,'=======================\n');
            result1=[];

            for i=1:size(methods,1)
                if(isempty(methods{i}))
                    break;
                end     
                
                switch methods{i}
                    case {'LINK_LDA','LINK_LDA_fold_in','PLSI_PHITS','PLSI_PHITS_inte'}
			netinput=rand_init_new(k,size(X,1)+size(citation,2),size(X,2));
                        netinput.Train=[Prob(:,TrainIndex); citation(TrainIndex,:)'];
                        netinput.Test=[Prob(:,TestIndex); citation(TestIndex,:)'];
                    otherwise
			netinput=rand_init_new(k,size(X,1),size(X,2));
                        netinput.Train=Prob(:,TrainIndex);
                        netinput.Test=Prob(:,TestIndex);
                end

		if(hasbase==1)
                	netinput.BASE=BASE;
                	netinput.tBASE=TEST_BASE;
            	end
            	netinput.k=k;

                switch methods{i}
                    case 'LINK_LDA'                        
                        fhandle=str2func('LCA_perplexity');
                    case 'LINK_LDA_fold_in'
                        fhandle=str2func('LCA_fold_in_perplexity');
                    case 'PLSI_PHITS'
                        fhandle=str2func('PLSI_perplexity');
                    case 'PLSI_PHITS_inte'
                        fhandle=str2func('PLSI_inte_perplexity');
                    otherwise
                        fhandle=str2func([methods{i},'_perplexity']);            
                end
                
                netinput.count=Prob(:,TestIndex);
                netinput.bG=rand(netinput.k,size(netinput.Test,2))+0.1;
                netinput.bG=nrmz(netinput.bG,1);


                tmp=fhandle(netinput,control);
                interval=length(tmp);
                result1=[result1 tmp];
            end
            result=[result;result1];
        end
	result=full(result);
        details(k,:,:)=result;
        [dummy,index]=min(result,[],1);
        tmp=[];
        
        for i=1:(size(result,2)/interval)
            tmp=[tmp result(index(interval*i-interval+1),(interval*i-interval+1):(interval*i))];
        end    
        
        result_base=[result_base;tmp];
 %   end
    result=mean(result_base,1);
    result_std=std(result_base,0,1);
    ret.mean=[ret.mean;k result];
    ret.var=[ret.var;k result_std];
    for i=1:size(result,2)
        fprintf(fid,'%.3f(%.3f)******',result(i),result_std(i));
    end
    fprintf(fid,'\n');
%     fprintf(fid,'AC,MI(LFN KL)=%.3f(%.3f), %.3f(%.3f)\n',result(1),result_std(1),result(2),result_std(2));
%     fprintf(fid,'AC,MI(LFN L2)=%.3f(%.3f), %.3f(%.3f)\n',result(3),result_std(3),result(4),result_std(4));
%     fprintf(fid,'AC,MI(NMF KL)=%.3f(%.3f), %.3f(%.3f)\n',result(5),result_std(5),result(6),result_std(6));
%     fprintf(fid,'AC,MI(NMF L2)=%.3f(%.3f), %.3f(%.3f)\n',result(7),result_std(7),result(8),result_std(8));
end
fclose(fid);
save(matfilename,'control','methods','paras','ret','details');
