function d = SimCos(a,b,df)
% EUCLIDEAN - computes distance matrix
%
% E = euclidean(A,B)
%
%    A - (DxM) matrix 
%    B - (DxN) matrix
%    df = 1, force diagonals to be zero; 0 (default), do not force
% 
% Returns:
%    E - (MxN) Cosine similarity between vectors in A and B
%
%
% Description : 
%    This fully vectorized (VERY FAST!) m-file computes the 
%    cosine distance between two vectors by:
%
%                 ||A-B|| = A.*B
%
% Example : 
%    A = rand(400,100); B = rand(400,200);
%    d = distance(A,B);


if (nargin < 2)
   error('Not enough input arguments');
end
if (size(a,1) ~= size(b,1))
   error('A and B should be of same dimensionality');
end
if ~(isreal(a)*isreal(b))
   disp('Warning: running distance.m with imaginary numbers.  Results may be off.'); 
end
ab=a'*b; 
d = real(ab); 
