function Rec(topics)
%Task 1:  UVB
% Find the most important citation in certin topis by V
%                   (maybe not in this topic, for example, the basic theory such as EM, NMF, but influence other papers) 
% 
%Give an example(for a well-known citation, give the influence in each topic)


% and Find the most "important" document in certain topics by VB, which is
% actually not most important document. 
% consider an extreme case, one
% document cites all other documents in the corpus and has every word in
% the vocabulary, one can expect this document is most important document.

% And try to
% differenriate them.

% Task 2: 
% For a given paper, find the papers which has most influnence on it. If we
% can do this, then we can construct a influence garph.

%Task 3:
% Inference on a new subset documents, find the most influential citations.

%Task 4: Draw some visuallization. 

net=load(topics);
datafile=net.net.datafile;
if ~isempty(strfind(datafile,'TDT10'))
   [word_id,word_text,word_tf]=textread('tdt_words.txt','%d %s %d');
end

if ~isempty(strfind(datafile,'Cora'))
    [word_id,word_text,word_tf,word_df]=textread('proc_paper_vocabulary.txt','%d %s %d %d');
    fid = fopen('cora_id_title.txt');    
    [raw_paper_id2, id_db, year]=textread('cora_paper_year.txt','%d %d %d');
    [proc_paper_id, raw_paper_id]=textread('proc_paper_id.txt','%d %d');
    
end

if ~isempty(strfind(datafile,'CiteSeer'))
    [word_id,word_text]=textread('citeseer_word.txt','%d %s');
    fid = fopen('citeseer_id_title.txt');    
    [proc_paper_id, raw_paper_id]=textread('citeseer_paper_id.txt','%d %d');
    raw_paper_id2=raw_paper_id;
    id_db=raw_paper_id;
end

%read the title information
paper_id={};
paper_title={};
file_count=0;
while (1)
    line=fgetl(fid);
    if(feof(fid))
	break;
    end
    tmp_id=strread(line,'%s',1);
    line(1:length(tmp_id{1}))=[];
    tmp_title=line;
    tmp_id=str2num(tmp_id{1});
    %tmp_title=strread(line,'%s','delimiter','\r');
    %[tmp_id,tmp_title]=strread(line,'%d %s');

    %tmp_id=textscan(fid,'%d',1,'delimiter',' ');
    paper_id={paper_id{:} tmp_id};
    %tmp_title=textscan(fid,'%s',1,'delimiter','\r');
    paper_title={paper_title{:} tmp_title};
    file_count=file_count+1
end
fclose(fid);

paper_id=cell2mat(paper_id);


Count=net.net.mData;

Ndoc=size(Count,2);
Nword=size(Count,1);
filename=strcat(topics,'.txt');
rec_result=strcat(topics,'_Rec');


F=net.net.F';
F=F(1:Nword,:);
G=net.net.G;
%citation distribution
if isfield(net.net,'V')
    V=nrmz(net.net.V',1);
end
if isfield(net.net,'rB')
    B=net.net.rB;
    B=B.Q*(B.U\(B.L\B.P));
end


top_words=20;
top_papers=20;

fid=fopen(filename,'w');

k_topics=size(F,2);
top_topics=k_topics;
if(top_topics>k_topics)
    top_topics=k_topics;
end

N=sum(Count(:));
p_d=sum(Count,1)'/N;



f_w_z_citation=[];
p_z_c=[];
if isfield(net.net,'rB')
    p_c=B*p_d;
    p_z_c=V*p_c;
    fprintf(fid,'===============================================\n');
    fprintf(fid,'The topic distribution of the citations: V\n');
    for i=1:k_topics
        fprintf(fid,'Topics #%d:%.3f\n',i,p_z_c(i));
    end
    fprintf(fid,'**********************\n');

    [dummy,index]=sort(-p_z_c);

    for i=1:top_topics
        tmp=index(i);
        fprintf(fid,'Top %d-th(%d) topic:%.3f\n',i,tmp,p_z_c(tmp));
    end
    
    fprintf(fid,'The fraction of the words for each topics(citations)\n');
    p_wz=F.*repmat(p_z_c',Nword,1);
    p_z_w=p_wz./repmat(sum(p_wz,2),1,k_topics);
    [dummy,index]=max(p_z_w,[],2);
    f_w_z=zeros(1,k_topics);
    for i=1:k_topics
        f_w_z(i)=length(find(index==i))/Nword;
    end
    
    for i=1:k_topics
        fprintf(fid,'Topics #%d:%.3f\n',i,f_w_z(i));
    end
    fprintf(fid,'**********************\n');

    [dummy,index]=sort(-f_w_z);

    for i=1:top_topics
        tmp=index(i);
        fprintf(fid,'Top %d-th(%d) topic:%.3f\n',i,tmp,f_w_z(tmp));
    end
    
    f_w_z_citation=f_w_z;

end
p_z_d=G*p_d;
fprintf(fid,'===============================================\n');
fprintf(fid,'The topic distribution of the documents: VB\n');
for i=1:k_topics
    fprintf(fid,'Topics #%d:%.3f\n',i,p_z_d(i));
end
fprintf(fid,'**********************\n');

[dummy,index]=sort(-p_z_d);

for i=1:top_topics
    tmp=index(i);
    fprintf(fid,'Top %d-th(%d) topic:%.3f\n',i,tmp,p_z_d(tmp));
end

fprintf(fid,'The fraction of the words for each topics(documents)\n');
p_wz=F.*repmat(p_z_d',Nword,1);
p_z_w=p_wz./repmat(sum(p_wz,2),1,k_topics);
[dummy,index]=max(p_z_w,[],2);
f_w_z=zeros(1,k_topics);
for i=1:k_topics
    f_w_z(i)=length(find(index==i))/Nword;
end

for i=1:k_topics
    fprintf(fid,'Topics #%d:%.3f\n',i,f_w_z(i));
end
f_w_z_docs=f_w_z;
fprintf(fid,'**********************\n');

[dummy,index]=sort(-f_w_z);

for i=1:top_topics
    tmp=index(i);
    fprintf(fid,'Top %d-th(%d) topic:%.3f\n',i,tmp,f_w_z(tmp));
end


fprintf(fid,'===============================================\n');
fprintf(fid,'the keywords for each topics\n');

keywords=[];
for i=1:k_topics
    [dummy,index_word]=sort(-F(:,i));
    %keywords=[keywords index_word(1:top_words)];
    fprintf(fid,'Topics #%d\n',i);
    for j=1:top_words
        tmp=index_word(j);
        fprintf(fid,'%s %.3f\n',word_text{tmp},F(tmp,i));
    end
    fprintf(fid,'\n');
end
%find the most influential citations and the documents in certain topic
p_d_z=G.*repmat(p_d',k_topics,1)./repmat(p_z_d,1,Ndoc);
p_z_t=[];
if isfield(net.net,'rB')
    fprintf(fid,'===============================================\n');
    fprintf(fid,'The most influnential citations in certain topcs\n');
    p_c_z=V.*repmat(p_c',k_topics,1)./repmat(p_z_c,1,Ndoc);
    for i=1:top_topics
        fprintf(fid,'Topics #%d\n',i);
        [dummy, index_paper]=sort(-p_c_z(i,:));
        for j=1:top_papers
            tmp=index_paper(j);
            fprintf(fid,'%d(%f):%s\n',net.net.id_map(tmp,2),p_c_z(i,tmp),paper_title{find(paper_id==id_db(find(raw_paper_id2==raw_paper_id((find(proc_paper_id==net.net.id_map(tmp,2)))))))});
        end
        fprintf(fid,'\n\n');
    end
    
    p_z_t=V*B*p_d_z';
    
end
fprintf(fid,'===============================================\n');
fprintf(fid,'The most "important" docments in certain topcs\n');

for i=1:top_topics
    fprintf(fid,'Topics #%d\n',i);
    [dummy, index_paper]=sort(-p_d_z(i,:));
    for j=1:top_papers
        tmp=index_paper(j);
        fprintf(fid,'%d(%f):%s\n',net.net.id_map(tmp,2),p_d_z(i,tmp),paper_title{find(paper_id==id_db(find(raw_paper_id2==raw_paper_id((find(proc_paper_id==net.net.id_map(tmp,2)))))))});
    end
    fprintf(fid,'\n\n');
end

fclose(fid);
save(rec_result,'p_z_c','p_z_d','f_w_z_citation','f_w_z_docs','p_z_t');
