function ret=ParaSelectionPerplexity(paras,control,methods)

if(paras.display)
    fprintf(1,'Input file=%s\n',paras.data);
end
load(paras.data);

control.proc_data=1;%original data
[Prob Data]=ProcessData(Data,control);
N=size(Prob,2);
% if ~exist('control','var')    
%     control.maxiter=100;
%     control.display=true;
%     control.degree=1;
%     control.alpha=0.99;
%     control.base=2;
%     control.suffix=1;
% end

k=length(find(unique(Label)>=0));
k=paras.k(1);
alpha_result=[];
fprintf(1,'k=%d\n',k);

alpha_start=0.04;
alpha_end=0.99;
alpha_step=0.05;
if isfield(paras,'alpha')
    alpha_start=paras.alpha;
    alpha_end=paras.alpha;
    alpha_step=paras.alpha;
end

perp=control.perplexity; %training set ratio
rand('state',control.seed);
trainno=ceil(N*perp);
index=randperm(N);
TrainIndex=index(1:trainno);
index(1:trainno)=[];
TestIndex=index;

X=Data(:,TrainIndex);
tX=Data(:,TestIndex);
if exist('citation','var')
    control.ocitation=citation(TrainIndex,TrainIndex);
    tmp=find(sum(control.ocitation,2)==0);
    if ~isempty(tmp)
        for i=1:length(tmp)
            control.ocitation(tmp(i),tmp(i))=1;
        end
    end
    control.ocitation=control.ocitation.*repmat(sqrt(sum(control.ocitation,1)),size(control.ocitation,1),1);
    

    control.tcitation=citation(TestIndex,TestIndex);
    tmp=find(sum(control.tcitation,2)==0);
    if ~isempty(tmp)
        for i=1:length(tmp)
            control.tcitation(tmp(i),tmp(i))=1;
        end
    end
    control.tcitation=control.tcitation.*repmat(sqrt(sum(control.tcitation,1)),size(control.tcitation,1),1);
 
    control.wcitation=citation([TestIndex TrainIndex],[TestIndex TrainIndex]);
    tmp=find(sum(control.wcitation,2)==0);
    if ~isempty(tmp)
        for i=1:length(tmp)
            control.wcitation(tmp(i),tmp(i))=1;
        end
    end
    control.wcitation=control.wcitation.*repmat(sqrt(sum(control.wcitation,1)),size(control.wcitation,1),1);
    
end

matfilename=paras.data;
for i=1:size(methods,1)
    if(isempty(methods{i}))
        break;
    end
    matfilename=strcat(matfilename,'_',methods{i});    
end
matfilename=strcat(matfilename,'_alpha_perp');
switch control.proc_data
    case 1,
        matfilename=strcat(matfilename,'_','raw');
    case 4,
        matfilename=strcat(matfilename,'_','tfidf');
end
matfilename=strcat(matfilename,'_',num2str(k));
matfilename=strcat(matfilename,'_',num2str(control.alpha));
matfilename=strcat(matfilename,'.mat');

for alpha=alpha_start:alpha_step:alpha_end    
    result=[];
    fprintf(1,'alpha=%.3f\n',alpha);    
    control.alpha=alpha;
    if exist('citation','var')
        control.citation=control.ocitation;
    end
    BASE=ComputeBase(X,control);     

    if exist('citation','var')
        control.citation=control.tcitation;
    end
    tBASE=ComputeBase(tX,control);
    
%     if exist('citation','var')
%         control.citation=control.wcitation;
%     end
%     wBASE=ComputeBase([tX X],control);

    rand('state',control.seed);
    for trial=1:paras.trial
        netinput=rand_init_new(k,size(X,1),size(X,2));
        netinput.BASE=BASE;        
        netinput.k=k;
        fprintf(1,'=======================\n');        

        netinput.tBASE=tBASE;
       % netinput.wBASE=wBASE;
        netinput.Train=Prob(:,TrainIndex);
        netinput.Test=Prob(:,TestIndex);
        netinput.count=Prob(:,TestIndex);
        netinput.bG=rand(netinput.k,size(netinput.Test,2))+0.1;
        netinput.bG=nrmz(netinput.bG,1);
%         netinput.wG=rand(netinput.k,size(netinput.Test,2)+size(netinput.Train,2))+0.1;
%         netinput.wG=nrmz(netinput.wG,1);
        tmp=[];
        for i=1:size(methods,1)
            if(isempty(methods{i}))
                break;
            end
            fhandle=str2func([methods{i},'_perplexity']);         
            tmp=[tmp fhandle(netinput,control)];
        end        
        result=[result;tmp];
    end

    [dummy,index]=min(result,[],1);
    dummy=result(index(1),:);
    
    alpha_result=[alpha_result;alpha dummy];    
end

ret=alpha_result;
save(matfilename,'control','paras','methods','ret');
