function ret=LCA_perplexity(netinput,control)
%Order: LDA, LDA+BASE without base for test data, LDA+BASE with the base
%for the test data
net=LCA(netinput.k);
net.alphaU=0.01;

net.U=netinput.F';
net.V=netinput.G';

ret=[];
control.eiter=2;
%LDA
model=LCA_learn_VB(net,netinput.Train,control);
loss=model.loss;

net.V=netinput.bG';
model=LCA_infer_VB(net,netinput.Test,control,model);

model.U=model.U(1:size(netinput.count,1),:);
likeli = LCA_likelihood_VB(model, netinput.count, model.V, model.gamma);
perplexity=exp(likeli/sum(netinput.count(:)));


ret=[ret loss perplexity 0 0];

fprintf(1,'Loss Perplexity(LDA)=');
for i=1:size(ret,2)
    fprintf(1,'%.3f******',ret(i));
end
fprintf(1,'\n');

