function net=LCA_base(netinput,control)

X=netinput.data;
gnd=netinput.label;

net=LCA(netinput.k);
net.alphaU=0.01;

net.U=netinput.F';
net.V=netinput.G';
net.rB=netinput.BASE;
control.eiter=2;

net=LCA_learn_VB_rb(net,X,control);
loss=-net.loss;

prob=(net.rB'*net.V)';
net.F=net.U';
net.G=prob;
net.oG=net.G;
net.G=nrmz(net.G,1);

[dummy,label]=max(prob,[],1);
label=label';

index=find(gnd>=0);
gnd=gnd(index);
label=label(index);

res=bestMap(gnd,label);
AC = length(find(gnd == res))/length(gnd);
MI = MutualInfo(gnd,label);

net.ac_mi=[loss AC MI];

fprintf(1,'-Loss,Accuracy, MI(LCA_Base)=');
for i=1:size(net.ac_mi,2)
        fprintf(1,'%.3f******',net.ac_mi(i));
end
fprintf(1,'\n');
