function B=ComputeBase(X,control)

if isfield(control,'citation')
    %fprintf(1,'citation is available\n');
    W=control.citation';
else
    options.NN=10;
    options.GraphDistanceFunction='SimCos';
    W=adjacency(options,X);    
    W=sparse(W);
end
%     SIGMA=40;
%     options=make_options;%     
%     options.GraphWeights='heat';
%     options.GraphWeightParam=SIGMA;
%     options.GraphNormalize=1;    
%     W=laplacian(options,control,X);
    %W=full(W);
    %fprintf(1,'inverting the matrix\n');
    %B=inv(eye(N)-W);
    %B=W';
    %W=W';
N=size(X,2);
alpha=control.alpha;
tic;

switch(control.base)
    case 1
        %B=(1-a)*(1-aW)^-1; W=D^-0.5 W D^0.5; normalize W
        tmp=sqrt(sum(W,1));
        W=W./(repmat(tmp,N,1).*repmat(tmp',1,N));
        W=W./repmat(sum(W,1),N,1);
        B=(eye(N)-alpha*W)\eye(N);
        B=(1-alpha)*B;
    case 2
        %B=(1-a)*(1-aW)^-1;normalize W
        W=W./repmat(sum(W,1),N,1);
        %B=(eye(N)-alpha*W)\eye(N);
        W=sparse(eye(N)-alpha*W)/(1-alpha);
        B=inv_sp_lu(W);
    case 3
        %B=(1-a)*I + aW
        W=W./repmat(sum(W,1),N,1);
        B=(1-alpha)*eye(N)+alpha*W;
    case 4%for timing purpose
        %B=(1-a)*(1-aW)^-1;normalize W
        W=W./repmat(sum(W,1),N,1);
        %B=(eye(N)-alpha*W)\eye(N);
        W=sparse(eye(N)-alpha*W)/(1-alpha);
        B=inv(W);
end
